% Complexity metric for ABCDE
% Do not call directly

function [beta, gamma] = abcde_complexity(img)

high_var = 18.2857;

res = sum(bitxor(img(1:7,:), img(2:8,:)),2);

avg = sum(res) / 7;
curr_var = var(res);
Er = (1/8) * (1-(curr_var/high_var))*avg;


res = sum(bitxor(img(:,1:7), img(:,2:8)),1);

avg = sum(res) / 7;
curr_var = var(res);
Ec = (1/8) * (1-(curr_var/high_var))*avg;

gamma = min(Er,Ec);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


freq = zeros(8);
% horizontal
for i=1:8

cur_element = img(i,1);
cur_length = 1;

for j=2:8
    j;
    if img(i,j)==cur_element
        cur_length = cur_length+1;
    else
        freq(i, cur_length) = freq(i, cur_length) + 1;
        cur_element = img(i,j);
        cur_length = 1;
    end
end
freq(i, cur_length) = freq(i, cur_length) + 1;

end


hs = zeros(1,8);
for i=1:8
    %i
    for j=1:8
        if freq(i,j) ~= 0
            %freq(i,j)
            %sum(freq(i,:))
            p_i = freq(i,j) / sum(freq(i,:));
            %sprintf('prod %f\n', freq(i,j) * log2(p_i))
            hs(i) = hs(i) - freq(i,j) * log2(p_i);
        end
    end 
end

%Hs = sum(hs / max(hs)) / 8


%vertical
freq = zeros(8,8);
for j=1:8

cur_element = img(1,j);
cur_length = 1;

for i=2:8
    %i
    if img(i,j)==cur_element
        cur_length = cur_length+1;
    else
        freq(cur_length,j) = freq(cur_length,j) + 1;
        cur_element = img(i,j);
        %sprintf('adding %d, cur element is %d\n', cur_length, cur_element)
        cur_length = 1;
        %freq
    end
end
freq(cur_length,j) = freq(cur_length,j) + 1;
%sprintf('adding %d \n', cur_length )

end



hr = zeros(1,8);
for j=1:8
    %i
    for i=1:8
        if freq(i,j) ~= 0
            p_i = freq(i,j) / sum(freq(:,j));
            hr(j) = hr(j) - freq(i,j) * log2(p_i);
        end
    end 
end
%Hr   = sum(hr / max(hr)) / 8

% if max(max(hr), max(hs))==max(hr)
%     disp('using hr');
% else
%     disp('using hs');
% end

if max(max(hr), max(hs))==0
    beta = 0;
else
    Hr = sum(hr / max(max(hr), max(hs))) / 8;
    Hs = sum(hs / max(max(hr), max(hs))) / 8;
    beta = min(Hr,Hs);    
end

