% A Block Complexity based Data Embedding watermarking alrogithm
% Input: 512x512 3 channel TIFF
% Output: 512x512 3 channel watermarked image

function lena3 = abcde(filename)

preprocess;

lena = imread(filename);
img_size = size(lena,1);
lena2 = double(lena);
img_size = size(lena2, 1);

% separate into color channels
lena_r = lena2(:,:,1);
lena_g = lena2(:,:,2);
lena_b = lena2(:,:,3);

% convert each plane into gray code
%lena_r_gc = dec2gray(lena_r(:,:));

% separate into bit planes (1 is msb, 8 is lsb)
% profile on -detail builtin

lena_r_gc = zeros(img_size,img_size,8);
lena_g_gc = zeros(img_size,img_size,8);
lena_b_gc = zeros(img_size,img_size,8);

for i=1:img_size
    for j=1:img_size
      
        if lena_r(i,j) ~= 0
        temp = dec2gray(lena_r(i,j),:);
        lena_r_gc(i,j,1) = temp(1);
        lena_r_gc(i,j,2) = temp(2);
        lena_r_gc(i,j,3) = temp(3);
        lena_r_gc(i,j,4) = temp(4);
        lena_r_gc(i,j,5) = temp(5);
        lena_r_gc(i,j,6) = temp(6);
        lena_r_gc(i,j,7) = temp(7);
        lena_r_gc(i,j,8) = temp(8);
        end
        
        if lena_g(i,j) ~= 0
        temp = dec2gray(lena_g(i,j),:);
        lena_g_gc(i,j,1) = temp(1);
        lena_g_gc(i,j,2) = temp(2);
        lena_g_gc(i,j,3) = temp(3);
        lena_g_gc(i,j,4) = temp(4);
        lena_g_gc(i,j,5) = temp(5);
        lena_g_gc(i,j,6) = temp(6);
        lena_g_gc(i,j,7) = temp(7);
        lena_g_gc(i,j,8) = temp(8);
        end
        
        if lena_b(i,j) ~= 0
        temp = dec2gray(lena_b(i,j),:);
        lena_b_gc(i,j,1) = temp(1);
        lena_b_gc(i,j,2) = temp(2);
        lena_b_gc(i,j,3) = temp(3);
        lena_b_gc(i,j,4) = temp(4);
        lena_b_gc(i,j,5) = temp(5);
        lena_b_gc(i,j,6) = temp(6);
        lena_b_gc(i,j,7) = temp(7);
        lena_b_gc(i,j,8) = temp(8);
        end

    end
    if mod(i,10)==0
        i    
    end
end

disp('finished separating bitplanes');

% measure each tile's complexity
threshold = .36;
beta_thresh = [.653 .580 .507 .434 .361 0 0 0];
gamma_thresh = [.409 .355 .301 .247 .193 0 0 0];
total = zeros(1,8);
length = 8;
max = 2 * length * (length-1);

for i=0:(img_size/length)-1
    i_start = (i*length)+1;
    i_fin = (i*length)+length;
    
    for j=0:(img_size/length)-1
        j_start = (j*length)+1;
        j_fin = (j*length)+length;
        for k=1:8
            [beta gamma] = abcde_complexity(lena_r_gc(i_start:i_fin, j_start:j_fin, k));
            if (beta > beta_thresh(k)) && (gamma > gamma_thresh(k))
                lena_r_gc(i_start:i_fin, j_start:j_fin, k) = round(rand(length));
                total(k) = total(k)+1;
            end
            
            [beta gamma] = abcde_complexity(lena_g_gc(i_start:i_fin, j_start:j_fin, k));
            if (beta > beta_thresh(k)) && (gamma > gamma_thresh(k))
                lena_g_gc(i_start:i_fin, j_start:j_fin, k) = round(rand(length));
                total(k) = total(k)+1;
            end
            
            [beta gamma] = abcde_complexity(lena_b_gc(i_start:i_fin, j_start:j_fin, k));
            if (beta > beta_thresh(k)) && (gamma > gamma_thresh(k))
                lena_b_gc(i_start:i_fin, j_start:j_fin, k) = round(rand(length));
                total(k) = total(k)+1;
            end
            
        end
    end
    i
end

sprintf('# blocks: %d, # bits: %d (%f%%)\n', sum(total), length*length*sum(total), (length*length*sum(total))/(img_size*img_size*8*3))

% concatenate bit planes
clear lena3;
lena3(:,:,1) = lena_r_gc(:,:,1)*128 + ...
               lena_r_gc(:,:,2)*64 + ...
               lena_r_gc(:,:,3)*32 + ...
               lena_r_gc(:,:,4)*16 + ...
               lena_r_gc(:,:,5)*8 + ...
               lena_r_gc(:,:,6)*4 + ...
               lena_r_gc(:,:,7)*2 + ...
               lena_r_gc(:,:,8)*1;
           
lena3(:,:,2) = lena_g_gc(:,:,1)*128 + ...
               lena_g_gc(:,:,2)*64 + ...
               lena_g_gc(:,:,3)*32 + ...
               lena_g_gc(:,:,4)*16 + ...
               lena_g_gc(:,:,5)*8 + ...
               lena_g_gc(:,:,6)*4 + ...
               lena_g_gc(:,:,7)*2 + ...
               lena_g_gc(:,:,8)*1;
           
lena3(:,:,3) = lena_b_gc(:,:,1)*128 + ...
               lena_b_gc(:,:,2)*64 + ...
               lena_b_gc(:,:,3)*32 + ...
               lena_b_gc(:,:,4)*16 + ...
               lena_b_gc(:,:,5)*8 + ...
               lena_b_gc(:,:,6)*4 + ...
               lena_b_gc(:,:,7)*2 + ...
               lena_b_gc(:,:,8)*1;
    

%lena3(:,:,1) = gray2dec(lena3(find(lena3(:,:,1))));
%lena3(:,:,1) = max(0, gray2dec(lena3(:,:,1)));
for i=1:img_size
    for j=1:img_size
        if lena3(i,j,1) > 0
            lena3(i,j,1) = gray2dec(lena3(i,j,1));
        end
        if lena3(i,j,2) > 0
            lena3(i,j,2) = gray2dec(lena3(i,j,2));
        end
        if lena3(i,j,3) > 0
            lena3(i,j,3) = gray2dec(lena3(i,j,3));
        end
    end
end






