
function genResults
    
    doResults('../memorial_image.mat','results_new/memorial');
    doResults('../belgium_float.mat','results_new/belgium');
    doResults('../smetered_float.mat','results_new/smetered');
    doResults('../nave_float.mat','results_new/nave', 0.02);
    
end

function doResults(srcfile,dstname,varargin)

    if exist([dstname '_res.mat'],'file') 
        disp(['Skipping ' dstname]);
        return
    end
    disp(['Processing ' dstname]);
    
    if length(varargin) > 0
        expos = varargin{1}
    end
    
    srcimage = load(srcfile);
    srcname = fieldnames(srcimage);
    
    srcimage = getfield(srcimage,srcname{1});
    
    if exist('expos','var')
        resimage1 = hdrEnc(srcimage,'cvx',1,'exp',expos);
        resimage2 = hdrEnc(srcimage,'exp',expos);
    else
        resimage1 = hdrEnc(srcimage,'cvx',1);
        resimage2 = hdrEnc(srcimage);
    end
    
    lumimage1 = hdrSimulate(resimage1);
    lumimage2 = hdrSimulate(resimage2);
    cmpimage = hdrResize(srcimage);
    
    lum1mean = mean(mean(lumimage1(:,:,2)));
    lum2mean = mean(mean(lumimage2(:,:,2)));
    cmpmean = mean(mean(cmpimage(:,:,2)));
    
    for i=-8:2:4
        i1 = lumimage1 / lum1mean * 2^i;
        i2 = lumimage2 / lum2mean * 2^i;
        ci = cmpimage / cmpmean * 2^i;
        imwrite(i1, sprintf('%s_co(%d).png',dstname,i));
        imwrite(i2, sprintf('%s_bs(%d).png',dstname,i));
        imwrite(ci, sprintf('%s_src(%d).png',dstname,i));
    end
    disp 'for done'
    e1 = (lumimage1 / lum1mean - cmpimage/ cmpmean) .^ 2;
    e2 = (lumimage2 / lum2mean - cmpimage/ cmpmean) .^ 2;
    
    max_e = max( max(e1(:)), max(e2(:)));
    min_e = min( min(e1(:)), min(e2(:)));
    
    save([dstname '_res.mat'], 'lumimage1', 'lumimage2', 'cmpimage');
    
    figure;
    imagesc(log((e1(:,:,1)+e1(:,:,2)+e1(:,:,3))/3)/log(10),[log(min_e)/log(10) log(max_e)/log(10)]);
    colormap hot;
    colorbar;
    title('Square error image of convex optimizer versus ideal, log_1_0 mapped')
    xlabel(sprintf('Error mean: %f, median: %f',mean(e1(:)),median(e1(:))));
    saveas(gcf,sprintf('%s_err_co.png',dstname));
    
    imagesc(log((e2(:,:,1)+e2(:,:,2)+e2(:,:,3))/3)/log(10),[log(min_e)/log(10) log(max_e)/log(10)]);
    colormap hot;
    colorbar;
    title('Square error image of basic optimizer versus ideal, log_1_0 mapped')
    xlabel(sprintf('Error mean: %f, median: %f',mean(e2(:)),median(e2(:))));
    saveas(gcf,sprintf('%s_err_bs.png',dstname));
    
    close all
end

    
    