import javax.swing.*;
import java.awt.event.*;
import java.io.File;


public class CMenuBar extends JMenuBar implements ActionListener {

	private JMenu fileMenu;
	private JMenuItem fileMenuSettings;
	private JMenuItem fileMenuExit;
	
		private JMenu aboutMenu;
	private JMenuItem aboutMenuAbout;

	private ColorCheck colorCheck;
	
	public CMenuBar(ColorCheck colorCheck) {
		super();
		
		this.colorCheck = colorCheck;
		
		fileMenu = new JMenu("File");
		fileMenu.setMnemonic(KeyEvent.VK_F);
		fileMenu.setToolTipText("File-related tasks, such as opening and closing.");
		this.add(fileMenu);
		
	
		fileMenuSettings = new JMenuItem("Settings...");
		fileMenuSettings.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_S, ActionEvent.CTRL_MASK));
		fileMenuSettings.addActionListener(this);
		fileMenu.add(fileMenuSettings);

		fileMenu.addSeparator();
		fileMenuExit = new JMenuItem("Exit");
		fileMenuExit.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_F4, ActionEvent.ALT_MASK));		
		fileMenuExit.addActionListener(this);
		fileMenu.add(fileMenuExit);
		
		aboutMenu = new JMenu("About");
		aboutMenu.setToolTipText("About ColorCheck");
		this.add(aboutMenu);
		aboutMenuAbout = new JMenuItem("About ColorCheck");
		aboutMenuAbout.addActionListener(this);
		aboutMenu.add(aboutMenuAbout);
		
	}
	
	public void actionPerformed(ActionEvent e) {
		if(e.getSource() == fileMenuSettings) {
			doFileSettings();
		} else if(e.getSource() == fileMenuExit) {
			doUserRequestExit();
		} else if(e.getSource() == aboutMenuAbout) {
			doAboutMenuAbout();
		}
	}
	
	protected void doFileSettings() {
		CDialogSettings cDialogSettings = new CDialogSettings(colorCheck);
		cDialogSettings.setVisible(true);
	}
	
	
	protected void doUserRequestExit() {
		colorCheck.ccExit();			
	}
	
	private void doAboutMenuAbout() {
		JOptionPane.showMessageDialog(colorCheck,
			    "ColorCheck: A Psych221/EE362 final project by Dingting Wang. dingting@stanford.edu",
			    "About ColorCheck",
			    JOptionPane.PLAIN_MESSAGE);
	}

}
