import java.awt.*;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;

import javax.swing.ImageIcon;

/*
 * Created on May 19, 2005
 *
 */

/**
 * @author Dingting
 *
 * Just a class to store the styles for drawing the GUI
 */
public class BVStyle {	
	public static final boolean DEBUG = true;
	
	//Layout fudge factor
	public static final int FUDGE_S = 5;
	public static final int FUDGE_M = 10;	
	public static final int FUDGE_L = 20;	
	
	//Panel Constants
	public static final int PANEL_WIDTH = 250 + FUDGE_L;
	public static final int CANVAS_WIDTH = 600;	
	public static final int CANVAS_HEIGHT = 700;
	public static final int CANVAS_PLAY_HEIGHT = 500;
	public static final int CATALOG_WIDTH = 150;
	public static final int CATALOG_SCROLL_WIDTH = 200;
	
	//Selection constants
	public static final int KNOB_WIDTH = 9;
	public static final Color KNOB_COLOR = Color.BLACK;
	public static final Color KNOB_FILL = new Color((float)0.5,(float)0.5,(float)0.5,(float)0.5);
	public static final Color ONDROP = Color.GREEN;
	
	//Shape defaults
	public static final int DEF_SIZE = 40;
	public static final int DEF_SPACING = 20;
	public static final Color DEF_COLOR = Color.GRAY; 
	
	//Borders
	public static final int BORDER_L = 3;
	public static final int BORDER_M = 2;	
	public static final int BORDER_S = 1;

	//Button Margins
	public static final Insets BUTTONM_L = new Insets(1,4,1,4);
	public static final Insets BUTTONM_S = new Insets(0,2,0,2);
	
	//Layout Rigid Areas
	public static final Dimension RA_X_L = new Dimension(10,0);
	public static final Dimension RA_X_S = new Dimension(5,0);
	public static final Dimension RA_X_SS = new Dimension(2,0);
	
	public static final Dimension RA_Y_L = new Dimension(0,10);
	public static final Dimension RA_Y_S = new Dimension(0,5);

	public static final Dimension GRAD_PREVIEW = new Dimension(70,70);
	public static final Dimension COLOR_PREVIEW = new Dimension(20,20);
	
	//Image preview size
	public static final Dimension ICON_S = new Dimension(20,20);
	public static final Dimension ICON_M = new Dimension(20,20);
	
	//Poss. size
	public static final Dimension POSS_L = new Dimension(60,60);
	public static final int POSS_NUMROW = 8;
	
	//Text field width
	public static final Dimension TF_W_L = new Dimension(150,20);
	public static final Dimension TF_W_M = new Dimension(100,20);
	public static final Dimension TF_W_S = new Dimension(50,20);
	public static final Dimension TF_W_SS = new Dimension(30,20);
	public static final int TF_CW_M = 4;
	public static final int TF_CW_L = 10;
	public static final int TF_CW_LM = 15;	
	public static final int TF_CW_LL = 20;
	
	//Default window titles
	public static final String TITLE_NAME = "BunnyWWAK";
	public static final String TITLE_SEP = " - ";
	public static final String TITLE_DIRTY = "*";
	public static final String TITLE_UNTITLED = "Untitled";

	//Common icons
	public static final ImageIcon iconRemove = new ImageIcon("bunnyres/BVGenericRemove.png"); 
	public static final ImageIcon iconUp = new ImageIcon("bunnyres/BVGenericUp.png"); 
	public static final ImageIcon iconDown = new ImageIcon("bunnyres/BVGenericDown.png");
	public static final ImageIcon iconLeft = new ImageIcon("bunnyres/BVGenericLeft.png"); 
	public static final ImageIcon iconRight = new ImageIcon("bunnyres/BVGenericRight.png");
	
	public static final ImageIcon iconBunny = new ImageIcon("bunnyres/BunnyIcon.png"); 	

	
	//Transition repaints
	public static final int TRANS_RP = 25;
	public static final int TRANS_DELAY = 10;
	
	public static int FONT_DEF_SIZE = 16;
	public static final String TEST_STR = "The quick brown fox jumped over the lazy dog. THE QUICK BROWN FOX JUMPED OVER THE LAZY DOG.";
	public static int getFontSizeForHeight(Font font, int height) {
		int size = 0;
		LineMetrics metrics = font.getLineMetrics(TEST_STR, new FontRenderContext(null, false, false));
		
		int lastHeight = 0;
		for(int i=0; i >=0; i++) {
			Font newFont = font.deriveFont(new Integer(i).floatValue());
			LineMetrics newMetrics = newFont.getLineMetrics(TEST_STR, new FontRenderContext(null, false, false));
			if((lastHeight <= height) && (height <= newMetrics.getHeight())) {
				size = i-1;
				break;
			}
			lastHeight = new Float(newMetrics.getHeight()).intValue();
		}
		if(size < 0) size = 0; 
		return size; 
	}
	public static int getHeightForFontSize(Font font, int size) {
		Font newFont = font.deriveFont(new Integer(size).floatValue());
		LineMetrics metrics = newFont.getLineMetrics(TEST_STR, new FontRenderContext(null, false, false));
		return (new Float(metrics.getHeight()).intValue()+1); 
	}
}
