import java.awt.*;
import java.awt.event.*;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.io.*;
import java.util.*;

import javax.swing.*;


public class ColorCheck extends JFrame implements ActionListener {

	private static final long serialVersionUID = 1L;
	private CMenuBar menuBar;
	protected Container content;
    private Random generator = new Random();
    private JButton buttonRegenerate;
    private JButton buttonRegenerateRandom;
    
	public ColorCheck() {
		super("ColorCheck by Dingting - V 0.1");
		
		this.setIconImage(new ImageIcon(CUtils.ICON_FILENAME).getImage());
		
		menuBar = new CMenuBar(this);
		this.setJMenuBar(menuBar);
		
		content = getContentPane();
		content.setLayout(new BorderLayout());
		
		generateCircles();
		
		JPanel panelTestArea = new JPanel();
		panelTestArea.setOpaque(true);
		panelTestArea.setPreferredSize(new Dimension(CUtils.TEST_AREA_VIEWABLE,CUtils.TEST_AREA_VIEWABLE));
		panelTestArea.setLayout(new BoxLayout(panelTestArea, BoxLayout.PAGE_AXIS));
		testArea = new TestArea();
		panelTestArea.add(testArea);
		content.add(panelTestArea, BorderLayout.CENTER);
		
		content.add(buttomButtons(), BorderLayout.SOUTH);
		
		this.setDefaultCloseOperation ( JFrame.DO_NOTHING_ON_CLOSE );
		WindowListener windowListener = new WindowAdapter() {
				public void windowClosing( WindowEvent w ) {
					menuBar.doUserRequestExit();
				}
			};
		this.addWindowListener( windowListener );
		
		pack();
		setVisible(true);
	}

	private JPanel buttomButtons() {
		JPanel panelBottomButtons = new JPanel();
		panelBottomButtons.setLayout(new BoxLayout(panelBottomButtons, BoxLayout.X_AXIS));
		panelBottomButtons.setAlignmentX(Component.LEFT_ALIGNMENT);

		buttonRegenerate = new JButton("Regenerate");
		buttonRegenerate.addActionListener(this);
		buttonRegenerate.setEnabled(false);
		panelBottomButtons.add(buttonRegenerate);

		buttonRegenerateRandom = new JButton("Regenerate with new random number");
		buttonRegenerateRandom.addActionListener(this);
		buttonRegenerateRandom.setEnabled(false);
		panelBottomButtons.add(buttonRegenerateRandom);
		
		return panelBottomButtons;
	}
	
	public void actionPerformed(ActionEvent e) {
		if(e.getSource() == buttonRegenerate) {
			filled = new boolean[CUtils.TEST_AREA_SIZE][CUtils.TEST_AREA_SIZE];
			circles = new ArrayList();
			generateCircles();
			repaint();
		} else if (e.getSource() == buttonRegenerateRandom) {
			buttonRegenerateRandom.setText("Regenerate with new random number " + "(Last number: " + testNum + ")");
			testNum = new Integer(generator.nextInt(89) + 10).toString();
			filled = new boolean[CUtils.TEST_AREA_SIZE][CUtils.TEST_AREA_SIZE];
			circles = new ArrayList();
			generateCircles();
			repaint();
		}
	}
	
	TestArea testArea;
	
	private class TestArea extends JComponent {
		public void paintComponent(Graphics g) {
			super.paintComponent(g);
			Graphics2D g2 = (Graphics2D) g;
			g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, // Anti-alias!
			        RenderingHints.VALUE_ANTIALIAS_ON);
			
			if(valuesSet) {

				
				Font newFont = new Font("SansSerif", Font.PLAIN, 400);
				GlyphVector glyph = newFont.createGlyphVector(new FontRenderContext(null,false,false), testNum);
				Shape glyphShape = glyph.getOutline(0,0);
				Rectangle glyphBounds = glyphShape.getBounds();
				int offsetX = (CUtils.TEST_AREA_VIEWABLE - glyphBounds.width)/2;
				int offsetY = (CUtils.TEST_AREA_VIEWABLE - glyphBounds.height)/2 + glyphBounds.height;
				glyphShape = glyph.getOutline(offsetX-BVStyle.FUDGE_L, offsetY);
				
				for(int i=0;i<circles.size();i++) {
					Rectangle currRect = (Rectangle)circles.get(i);
					double briVarDivider = CUtils.BRI_VAR_MAX;
					double Y = (generator.nextDouble() - 0.5)*(briVarDouble/briVarDivider) + 0.5;
					double colorPos;
					double hueSepDivider = CUtils.HUE_SEP_MAX*2;
					double hueSepDoubleRatio = hueSepDouble/hueSepDivider;
					double hueVarDivider = CUtils.HUE_VAR_MAX;
					
					if(glyphShape.contains(currRect.x, currRect.y)) {
						colorPos = 0.5 - hueSepDoubleRatio;
						colorPos += (generator.nextDouble() - 0.5)*(hueVarDouble/hueVarDivider);						
					} else {
						colorPos = 0.5 + hueSepDoubleRatio;
						colorPos += (generator.nextDouble() - 0.5)*(hueVarDouble/hueVarDivider);
					}
					
					if(colorPos < 0) colorPos = 0;
					if(colorPos > 1) colorPos = 1;
					
					double x;
					double y;
					if(confPointOneX>confPointTwoX) {
						x = (confPointOneX-confPointTwoX)*colorPos + confPointTwoX;
						y = (confPointOneY-confPointTwoY)*colorPos + confPointTwoY;						
					} else {
						x = (confPointTwoX-confPointOneX)*colorPos + confPointOneX;
						y = (confPointTwoY-confPointOneY)*colorPos + confPointOneY;	
					}
					
					Color currColor = CUtils.xyY_to_sRGB(x,y,Y);
					g2.setColor(currColor);
					
					g2.fillOval(currRect.x, currRect.y, currRect.width, currRect.height);					
				}
			} else {
				g2.setFont(new Font("SansSerif", Font.PLAIN, 50));
				g2.drawString("Set settings first", CUtils.TEST_AREA_VIEWABLE/8,CUtils.TEST_AREA_VIEWABLE/2);
			}
		}
	}
	
	private boolean[][] filled = new boolean[CUtils.TEST_AREA_SIZE][CUtils.TEST_AREA_SIZE];
	private ArrayList circles = new ArrayList();
	private void generateCircles() {
	    for(int k=0;k<5;k++) {
			for(int i=0;i<CUtils.TEST_AREA_SIZE;i++) {
				for(int j=0;j<CUtils.TEST_AREA_SIZE;j++) {
					if(!filled[i][j]) {
						int size = generator.nextInt(CUtils.CIRCLE_MAX_DIAM-CUtils.CIRCLE_MIN_DIAM)+CUtils.CIRCLE_MIN_DIAM;
						int sizeOrig = size;
						for(;size>=sizeOrig-2;size--){
							boolean intersect = false;
							for(int m=i;m<i+size && m<CUtils.TEST_AREA_SIZE;m++) {
								for(int n=j;n<j+size && n<CUtils.TEST_AREA_SIZE;n++) {
									if(filled[m][n]) {
										//size--;
										intersect = true;
									}
									if(intersect) break;
								}
								if(intersect) break;
							}
							if(!intersect) {
								for(int m=i;m<i+size && m<CUtils.TEST_AREA_SIZE;m++) {
									for(int n=j;n<j+size && n<CUtils.TEST_AREA_SIZE;n++) {
										filled[m][n] = true;
									}
								}
								Rectangle addedRect = new Rectangle(i,j,size,size);
								circles.add(addedRect);
								break;
							}
						}
					}
				}			
			}
	    }
	}
	
	protected void ccExit() {
		/* Exit after clean up, save, etc.*/
		setVisible(false);
		dispose();
		System.exit(0);
	}
	

	protected double confPointOneX;
	protected double confPointOneY;
	protected double confPointTwoX;
	protected double confPointTwoY;
	protected int briVar;
	protected int hueVar;
	protected int hueSep;
	private int briVarDouble;
	private int hueVarDouble;
	private int hueSepDouble;
	protected boolean randomTest;
	protected String testNum = "";
	protected boolean valuesSet = false;
	protected int confButtonNum;
	protected void setColorCheckValues( double confPointOneX,	double confPointOneY,
										double confPointTwoX,  double confPointTwoY,
				int briVar,	int hueVar,	int hueSep,	boolean randomTest,	String testNumStr, int confButtonNum) {
		this.confPointOneX = confPointOneX;
		this.confPointOneY = confPointOneY;
		this.confPointTwoX = confPointTwoX;
		this.confPointTwoY = confPointTwoY;
		this.confButtonNum = confButtonNum;
		this.briVar = briVar;
		this.hueVar = hueVar;
		this.hueSep = hueSep;
		briVarDouble = briVar;
		hueVarDouble = hueVar;
		hueSepDouble = hueSep;
		this.randomTest = randomTest;
		buttonRegenerate.setEnabled(true);
		if(randomTest) {
			testNum = new Integer(generator.nextInt(89) + 10).toString();
			buttonRegenerateRandom.setEnabled(true);
			
			//System.out.println("Random: " + testNum);
		} else {
			buttonRegenerateRandom.setEnabled(false);
			this.testNum = testNumStr;
			//System.out.println("Not Random: " + testNum);
		}
		buttonRegenerateRandom.setText("Regenerate with new random number");

		valuesSet = true;
	}
	
	public static void main(String[] args) {
		// TODO Auto-generated method stub
		if(UIManager.getSystemLookAndFeelClassName() == "com.sun.java.swing.plaf.windows.WindowsLookAndFeel") {
			try {
				UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
			} catch (Exception e) { }
		}

		
		ColorCheck colorCheck = new ColorCheck();
	}
}
