import java.awt.*;

public class CUtils {
	public static String CIE_FILENAME = "CIE1931_1_to_500px.png";
	public static String ICON_FILENAME = "CIE1931_icon.png";
	
	
	public static int TEST_AREA_VIEWABLE = 500;
	public static int TEST_AREA_SIZE = 550;
	
	public static int CIRCLE_MAX_DIAM = 20;
	public static int CIRCLE_MIN_DIAM = 6;
	
	public static int CIE_X_OFFSET = 24;
	public static int CIE_Y_OFFSET = 442;
	
	public static int CIE_HEIGHT = 467;
	
	public static int BRI_VAR_MIN = 0;
	public static int BRI_VAR_MAX = 50;
	public static int BRI_VAR_INIT = 15;
	
	public static int HUE_VAR_MIN = 0;
	public static int HUE_VAR_MAX = 50;
	public static int HUE_VAR_INIT = 10;

	public static int HUE_SEP_MIN = 0;
	public static int HUE_SEP_MAX = 100;
	public static int HUE_SEP_INIT = 50;

	
	// 1 pixel is 0.002 in terms of CIE x or y coordinates
	public static double CIE_SCALE = 500;
	public static double PIXEL_TO_CIE = 0.002;
	
	//(1.4,-0.4) to Green primary
	public static double DEU_A_ONE_X = 0.613191;
	public static double DEU_A_ONE_Y = 0.315254;
	public static double DEU_A_TWO_X = 0.3;
	public static double DEU_A_TWO_Y = 0.6;

	//(1.4,-0.4) through whitepoint
	public static double DEU_B_ONE_X = 0.459484;
	public static double DEU_B_ONE_Y = 0.230585;
	public static double DEU_B_TWO_X = 0.238535;
	public static double DEU_B_TWO_Y = 0.378725;
	
	//(.7464, .2535) through Green primary
	public static double PRO_A_ONE_X = 0.64;
	public static double PRO_A_ONE_Y = 0.33;
	public static double PRO_A_TWO_X = 0.294031;
	public static double PRO_A_TWO_Y = 0.578513;

	//(.7464, .2535) through whitepoint
	public static double PRO_B_ONE_X = 0.559982;
	public static double PRO_B_ONE_Y = 0.285962;
	public static double PRO_B_TWO_X = 0.228779;
	public static double PRO_B_TWO_Y = 0.343606;

	
	public static Point sRGB_RED = new Point(	(new Double(0.64*CIE_SCALE)).intValue(),
										(new Double(0.33*CIE_SCALE)).intValue());

	public static Point sRGB_GREEN = new Point((new Double(0.30*CIE_SCALE)).intValue(),
										(new Double(0.60*CIE_SCALE)).intValue());

	public static Point sRGB_BLUE = new Point(	(new Double(0.15*CIE_SCALE)).intValue(),
										(new Double(0.06*CIE_SCALE)).intValue());
	
	public static Color sRGB_GAMUT_COLOR = new Color(0,0,0,212);
	
	public static Color CONF_COLOR = new Color(255,255,255,212);
	
	public static Color HUE_COLOR = new Color(0,0,0,128);
	
	
	public static Polygon sRGB_GAMUT = new Polygon(
			new int[] {CIE_X_OFFSET + sRGB_RED.x, CIE_X_OFFSET + sRGB_GREEN.x, CIE_X_OFFSET + sRGB_BLUE.x},
			new int[] {CIE_Y_OFFSET - sRGB_RED.y, CIE_Y_OFFSET - sRGB_GREEN.y, CIE_Y_OFFSET - sRGB_BLUE.y},
			3);
	
	public static Point xy_to_Pixels(double x, double y) {
		return new Point(CIE_X_OFFSET + (new Double(x*CIE_SCALE)).intValue(),
				CIE_Y_OFFSET - (new Double(y*CIE_SCALE)).intValue());
	}
	
	public static Color xyY_to_sRGB(double x, double y, double Y) {
		//xyY to XYZ, source: http://en.wikipedia.org/wiki/CIE_XYZ_color_space
		double X = (Y/y)*x;
		double Z = (Y/y)*(1-x-y);
		
		//XYZ to sRGB, source: http://www.srgb.com/basicsofsrgb.htm
		double R =  3.2406*X -1.5372*Y -0.4986*Z;
		double G = -0.9689*X +1.8758*Y +0.0415*Z;
		double B =  0.0557*X -0.2040*Y +1.0570*Z;
		
		if(R < 0) R = 0;
		if(R > 1) R = 1;
		if(G < 0) G = 0;
		if(G > 1) G = 1;
		if(B < 0) B = 0;
		if(B > 1) B = 1;
		
		return new Color(	new Double(R).floatValue(), 
							new Double(G).floatValue(), 
							new Double(B).floatValue());
	}
}
