import java.awt.event.*;
import java.awt.geom.AffineTransform;

import javax.swing.*;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import java.awt.*;


public class CDialogSettings extends JDialog implements ActionListener, ChangeListener{

	private JRadioButton confPresetDeuA;
	private JRadioButton confPresetDeuB;
	private JRadioButton confPresetProA;	
	private JRadioButton confPresetProB;	
	private JRadioButton confCustom;
	
	private ButtonGroup confButtons;

	private JTextField textTestNum;
	
	private ColorCheck colorCheck;
	
	private JPanel panelConfSet;
	private JPanel panelCieXY;
	private JPanel panelGenSet;
	
	public CDialogSettings(ColorCheck colorCheck) {
		super(colorCheck, "ColorCheck Generation Settings", true);
		this.colorCheck = colorCheck;

        Container contentPane = getContentPane();
        contentPane.setLayout(new BorderLayout());

        contentPane.add(confSet(), BorderLayout.WEST);
        contentPane.add(cieXY(), BorderLayout.CENTER);
		contentPane.add(genSet(), BorderLayout.EAST);
		contentPane.add(backControl(), BorderLayout.SOUTH);
		
		confButtons = new ButtonGroup();
		confButtons.add(confPresetDeuA);
		confButtons.add(confPresetDeuB);
		confButtons.add(confPresetProA);
		confButtons.add(confPresetProB);
		confButtons.add(confCustom);		
		
        //Initialize values.
        pack();
        setLocationRelativeTo(colorCheck);
	}
	
	JButton buttonCancel;
	JButton buttonSet;
	private JPanel backControl() {
		JPanel panelControl = new JPanel();
		panelControl.setOpaque(true);
		panelControl.setLayout(new BoxLayout(panelControl, BoxLayout.X_AXIS));
		panelControl.setAlignmentX(Component.LEFT_ALIGNMENT);

		buttonSet = new JButton("Set");
		buttonSet.setMargin(BVStyle.BUTTONM_L);
		buttonSet.setToolTipText("Set");
		buttonSet.addActionListener(this);
		panelControl.add(buttonSet);
		
		panelControl.add(Box.createRigidArea(BVStyle.RA_X_S));
		
		buttonCancel = new JButton("Cancel");
		buttonCancel.setMargin(BVStyle.BUTTONM_L);
		buttonCancel.setToolTipText("Cancel");
		buttonCancel.addActionListener(this);
		panelControl.add(buttonCancel);
		
		return panelControl;
	}
	
	JLabel labelConfCustomOne;
	JLabel labelConfCustomTwo;
	
	private JPanel confSet() {
		panelConfSet = new JPanel();
		panelConfSet.setOpaque(true);
		panelConfSet.setLayout(new BoxLayout(panelConfSet, BoxLayout.Y_AXIS));
		panelConfSet.setAlignmentX(Component.LEFT_ALIGNMENT);
		panelConfSet.setBorder(BorderFactory.createCompoundBorder(
                BorderFactory.createTitledBorder("Confusion Line Tested"),
                BorderFactory.createEmptyBorder(BVStyle.BORDER_S,BVStyle.BORDER_S,BVStyle.BORDER_S,BVStyle.BORDER_S)));

		confPresetDeuA = new JRadioButton("Deuteranope Preset A");
		confPresetDeuA.addActionListener(this);
		panelConfSet.add(confPresetDeuA);
		confPresetDeuB = new JRadioButton("Deuteranope Preset B");
		confPresetDeuB.addActionListener(this);
		panelConfSet.add(confPresetDeuB);
		confPresetProA = new JRadioButton("Protanope Preset A");
		confPresetProA.addActionListener(this);
		panelConfSet.add(confPresetProA);
		confPresetProB = new JRadioButton("Protanope Preset B");
		confPresetProB.addActionListener(this);
		panelConfSet.add(confPresetProB);
		confCustom = new JRadioButton("Custom Settings");
		confCustom.addActionListener(this);
		panelConfSet.add(confCustom);
		
		labelConfCustomOne = new JLabel("Custom Pt 1: ");
		panelConfSet.add(labelConfCustomOne);

		labelConfCustomTwo = new JLabel("Custom Pt 2: ");		
		panelConfSet.add(labelConfCustomTwo);
		
		if(colorCheck.valuesSet) {
	        if(colorCheck.confButtonNum == 1) {
				confOneX = CUtils.DEU_A_ONE_X;
				confOneY = CUtils.DEU_A_ONE_Y;
				confTwoX = CUtils.DEU_A_TWO_X;
				confTwoY = CUtils.DEU_A_TWO_Y;
	        	confPresetDeuA.setSelected(true);
	        } else if(colorCheck.confButtonNum == 2) {
				confOneX = CUtils.DEU_B_ONE_X;
				confOneY = CUtils.DEU_B_ONE_Y;
				confTwoX = CUtils.DEU_B_TWO_X;
				confTwoY = CUtils.DEU_B_TWO_Y;
	        	confPresetDeuB.setSelected(true);
	        } else if(colorCheck.confButtonNum == 3) {
				confOneX = CUtils.PRO_A_ONE_X;
				confOneY = CUtils.PRO_A_ONE_Y;
				confTwoX = CUtils.PRO_A_TWO_X;
				confTwoY = CUtils.PRO_A_TWO_Y;
	        	confPresetProA.setSelected(true);
	        } else if(colorCheck.confButtonNum == 4) {
				confOneX = CUtils.PRO_B_ONE_X;
				confOneY = CUtils.PRO_B_ONE_Y;
				confTwoX = CUtils.PRO_B_TWO_X;
				confTwoY = CUtils.PRO_B_TWO_Y;
	        	confPresetProB.setSelected(true);
	        } else {
				confOneX = colorCheck.confPointOneX;
				confOneY = colorCheck.confPointOneY;
				confTwoX = colorCheck.confPointTwoX;
				confTwoY = colorCheck.confPointTwoY;
	        	confCustom.setSelected(true);
	        	
				String xCoord = new Double(confOneX).toString();
				if(xCoord.length() > 5) {
					xCoord = xCoord.substring(0,4);
				}
				String yCoord = new Double(confOneY).toString();
				if(yCoord.length() > 5) {
					yCoord = yCoord.substring(0,4);
				}			
				labelConfCustomOne.setText("Custom Pt 1: (" + xCoord + "," + yCoord + ")");
				xCoord = new Double(confTwoX).toString();
				if(xCoord.length() > 5) {
					xCoord = xCoord.substring(0,4);
				}
				yCoord = new Double(confTwoY).toString();
				if(yCoord.length() > 5) {
					yCoord = yCoord.substring(0,4);
				}	
				
				labelConfCustomTwo.setText("Custom Pt 2: (" + xCoord + "," + yCoord + ")");
		    }
		} else {
			confPresetDeuA.setSelected(true);
			confOneX = CUtils.DEU_A_ONE_X;
			confOneY = CUtils.DEU_A_ONE_Y;
			confTwoX = CUtils.DEU_A_TWO_X;
			confTwoY = CUtils.DEU_A_TWO_Y;
		}
		
		return panelConfSet;
	}
	
	private class CPanelCIE extends JComponent  {
		public CPanelCIE() {
			super();
			
			addMouseListener( new MouseAdapter() {
				public void mousePressed(MouseEvent e) {
					if(confCustom.isSelected()) {
						double xPixel = e.getX() - CUtils.CIE_X_OFFSET;
						confOneX = xPixel*CUtils.PIXEL_TO_CIE;
						double yPixel = CUtils.CIE_Y_OFFSET - e.getY();
						confOneY = yPixel*CUtils.PIXEL_TO_CIE;			
						confTwoX = confOneX;
						confTwoY = confOneY;
						
						String xCoord = new Double(confOneX).toString();
						if(xCoord.length() > 5) {
							xCoord = xCoord.substring(0,4);
						}
						String yCoord = new Double(confOneY).toString();
						if(yCoord.length() > 5) {
							yCoord = yCoord.substring(0,4);
						}
						
						
						labelConfCustomOne.setText("Custom Pt 1: (" + xCoord + "," + yCoord + ")");
						labelConfCustomTwo.setText("Custom Pt 2: (" + xCoord + "," + yCoord + ")");
						repaint();

					}
				}
			});
		

			addMouseMotionListener( new MouseMotionAdapter() {
				public void mouseDragged(MouseEvent e) {
					if (confCustom.isSelected()) {
						double xPixel = e.getX() - CUtils.CIE_X_OFFSET;
						confTwoX = xPixel*CUtils.PIXEL_TO_CIE;
						double yPixel = CUtils.CIE_Y_OFFSET - e.getY();
						confTwoY = yPixel*CUtils.PIXEL_TO_CIE;		
						
						String xCoord = new Double(confTwoX).toString();
						if(xCoord.length() > 5) {
							xCoord = xCoord.substring(0,4);
						}
						String yCoord = new Double(confTwoY).toString();
						if(yCoord.length() > 5) {
							yCoord = yCoord.substring(0,4);
						}
						
						labelConfCustomTwo.setText("Custom Pt 2: (" + xCoord + "," + yCoord + ")");
						repaint();
					}
				}
			});
		}
		
		public void paintComponent(Graphics g) {
			super.paintComponent(g);

	        Graphics2D g2 = (Graphics2D) g;
	        ImageIcon image = new ImageIcon(CUtils.CIE_FILENAME);
	        AffineTransform transform = new AffineTransform();

	        if(image != null) {
	        	g2.drawImage(image.getImage(), transform, null);
	        }
			g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, // Anti-alias!
			        RenderingHints.VALUE_ANTIALIAS_ON);
			g2.setStroke(new BasicStroke(1.5f));
			g2.setFont(new Font("SansSerif", Font.BOLD, 16));
			
	        g2.setColor(CUtils.sRGB_GAMUT_COLOR);
	        g2.drawPolygon(CUtils.sRGB_GAMUT);
	        g2.setColor(CUtils.CONF_COLOR);
			g2.drawString("sRGB Gamut", CUtils.sRGB_GAMUT.xpoints[1]-125, CUtils.sRGB_GAMUT.ypoints[1]+25);
			g2.setColor(CUtils.sRGB_GAMUT_COLOR);
			g2.drawString("sRGB Gamut", CUtils.sRGB_GAMUT.xpoints[1]+1-125, CUtils.sRGB_GAMUT.ypoints[1]+1+25);
	        
	        g2.setColor(CUtils.CONF_COLOR);
	        Point pointOne = CUtils.xy_to_Pixels(confOneX,confOneY);
	        Point pointTwo = CUtils.xy_to_Pixels(confTwoX,confTwoY);
			g2.setStroke(new BasicStroke(2.5f));
	        g2.drawLine(pointOne.x, pointOne.y, pointTwo.x, pointTwo.y);
	        
			g2.setFont(new Font("SansSerif", Font.PLAIN, 12));
	        g2.setColor(CUtils.CONF_COLOR);
			g2.drawString("Confusion Line", pointTwo.x, pointTwo.y);
			g2.setColor(CUtils.sRGB_GAMUT_COLOR);
			g2.drawString("Confusion Line", pointTwo.x+1, pointTwo.y+1);
	        
			
			double colorPosOneStart;
			double colorPosOneEnd;
			double colorPosTwoStart;
			double colorPosTwoEnd;
			
			double hueOneXStart;
			double hueOneXEnd;
			double hueOneYStart;
			double hueOneYEnd;
			
			double hueTwoXStart;
			double hueTwoXEnd;
			double hueTwoYStart;
			double hueTwoYEnd;
	
			double hueSepDivider = CUtils.HUE_SEP_MAX*2;
			double hueSepDoubleRatio = new Integer(hueSeperation.getValue()).doubleValue()/hueSepDivider;
			double hueVarDivider = CUtils.HUE_VAR_MAX;
			double hueVarDividerRatio = new Integer(hueVariation.getValue()).doubleValue()/hueVarDivider;

			colorPosOneStart = 0.5 - hueSepDoubleRatio + hueVarDividerRatio*0.5;
			colorPosOneEnd	 = 0.5 - hueSepDoubleRatio - hueVarDividerRatio*0.5;			
			colorPosTwoStart = 0.5 + hueSepDoubleRatio + hueVarDividerRatio*0.5;
			colorPosTwoEnd	 = 0.5 + hueSepDoubleRatio - hueVarDividerRatio*0.5;		
			if(colorPosOneStart < 0) colorPosOneStart = 0;
			if(colorPosOneStart > 1) colorPosOneStart = 1;
			if(colorPosOneEnd < 0) colorPosOneEnd = 0;
			if(colorPosOneEnd > 1) colorPosOneEnd = 1;
			if(colorPosTwoStart < 0) colorPosTwoStart = 0;
			if(colorPosTwoStart > 1) colorPosTwoStart = 1;
			if(colorPosTwoEnd < 0) colorPosTwoEnd = 0;
			if(colorPosTwoEnd > 1) colorPosTwoEnd = 1;
			
			hueOneXStart = (confOneX-confTwoX)*colorPosOneStart + confTwoX;
			hueOneYStart = (confOneY-confTwoY)*colorPosOneStart + confTwoY;				
			
			hueOneXEnd = (confOneX-confTwoX)*colorPosOneEnd + confTwoX;
			hueOneYEnd = (confOneY-confTwoY)*colorPosOneEnd + confTwoY;		
			
			hueTwoXStart = (confOneX-confTwoX)*colorPosTwoStart + confTwoX;
			hueTwoYStart = (confOneY-confTwoY)*colorPosTwoStart + confTwoY;				
			
			hueTwoXEnd = (confOneX-confTwoX)*colorPosTwoEnd + confTwoX;
			hueTwoYEnd = (confOneY-confTwoY)*colorPosTwoEnd + confTwoY;		
	        
			g2.setColor(CUtils.HUE_COLOR);
			g2.setStroke(new BasicStroke(5f));
			
	        Point pointHueOneStart = CUtils.xy_to_Pixels(hueOneXStart,hueOneYStart);
	        Point pointHueOneEnd = CUtils.xy_to_Pixels(hueOneXEnd,hueOneYEnd);
	        Point pointHueTwoStart = CUtils.xy_to_Pixels(hueTwoXStart,hueTwoYStart);
	        Point pointHueTwoEnd = CUtils.xy_to_Pixels(hueTwoXEnd,hueTwoYEnd);
	        
	        g2.drawLine(pointHueOneStart.x, pointHueOneStart.y, pointHueOneEnd.x, pointHueOneEnd.y);
	        g2.drawLine(pointHueTwoStart.x, pointHueTwoStart.y, pointHueTwoEnd.x, pointHueTwoEnd.y);
       
			g2.setFont(new Font("SansSerif", Font.PLAIN, 10));
	        g2.setColor(CUtils.CONF_COLOR);
			g2.drawString("Hue Range 1", (pointHueOneStart.x+pointHueOneEnd.x)/2, (pointHueOneStart.y+pointHueOneEnd.y)/2);
			g2.drawString("Hue Range 2", (pointHueTwoStart.x+pointHueTwoEnd.x)/2, (pointHueTwoStart.y+pointHueTwoEnd.y)/2);
			g2.setColor(CUtils.sRGB_GAMUT_COLOR);
			g2.drawString("Hue Range 1", (pointHueOneStart.x+pointHueOneEnd.x)/2+1, (pointHueOneStart.y+pointHueOneEnd.y)/2+1);
			g2.drawString("Hue Range 2", (pointHueTwoStart.x+pointHueTwoEnd.x)/2+1, (pointHueTwoStart.y+pointHueTwoEnd.y)/2+1);

			

	        
	        
		}
	}
	
	private JPanel cieXY() {
		JPanel panelCieXY = new JPanel();
		panelCieXY.setOpaque(true);
		panelCieXY.setPreferredSize(new Dimension(CUtils.CIE_HEIGHT,CUtils.CIE_HEIGHT));
		panelCieXY.setLayout(new BoxLayout(panelCieXY, BoxLayout.PAGE_AXIS));
		panelCieXY.add(new CPanelCIE());
		
		return panelCieXY;		
	}
	
	
	private JSlider brightnessVariation;
	private JLabel labelBriVar;
	private JSlider hueVariation;
	private JLabel labelHueVar;
	private JSlider hueSeperation;
	private JLabel labelHueSep;
	private JCheckBox checkRandom;
	
	private JPanel genSet() {
		panelGenSet = new JPanel();
		panelGenSet.setOpaque(true);
		panelGenSet.setLayout(new BoxLayout(panelGenSet, BoxLayout.Y_AXIS));
		panelGenSet.setAlignmentX(Component.LEFT_ALIGNMENT);
		panelGenSet.setBorder(BorderFactory.createCompoundBorder(
                BorderFactory.createTitledBorder("Generation Settings"),
                BorderFactory.createEmptyBorder(BVStyle.BORDER_S,BVStyle.BORDER_S,BVStyle.BORDER_S,BVStyle.BORDER_S)));


		panelGenSet.add(new JLabel("Brightness Variation:"));
		if(colorCheck.valuesSet) {
			brightnessVariation = new JSlider(JSlider.HORIZONTAL, CUtils.BRI_VAR_MIN, 
				CUtils.BRI_VAR_MAX, colorCheck.briVar);
		} else {
			brightnessVariation = new JSlider(JSlider.HORIZONTAL, CUtils.BRI_VAR_MIN, 
					CUtils.BRI_VAR_MAX, CUtils.BRI_VAR_INIT);
		}
		brightnessVariation.addChangeListener(this);
		panelGenSet.add(brightnessVariation);
		brightnessVariation.setAlignmentX(Component.LEFT_ALIGNMENT);
		brightnessVariation.setMajorTickSpacing(10);
		brightnessVariation.setMinorTickSpacing(5);
		brightnessVariation.setPaintTicks(true);
		brightnessVariation.setPaintLabels(true);
		labelBriVar = new JLabel();
		labelBriVar.setText("Current value: " + new Integer(brightnessVariation.getValue()).toString());
		panelGenSet.add(labelBriVar);
		
		panelGenSet.add(Box.createRigidArea(BVStyle.RA_Y_L));
		
		panelGenSet.add(new JLabel("Hue Variation:"));
		if(colorCheck.valuesSet) {
			hueVariation = new JSlider(JSlider.HORIZONTAL, CUtils.HUE_VAR_MIN, 
				CUtils.HUE_VAR_MAX, colorCheck.hueVar);
		} else {
			hueVariation = new JSlider(JSlider.HORIZONTAL, CUtils.HUE_VAR_MIN, 
					CUtils.HUE_VAR_MAX, CUtils.HUE_VAR_INIT);			
		}
		panelGenSet.add(hueVariation);
		hueVariation.setAlignmentX(Component.LEFT_ALIGNMENT);
		hueVariation.setMajorTickSpacing(10);
		hueVariation.setMinorTickSpacing(5);
		hueVariation.setPaintTicks(true);
		hueVariation.setPaintLabels(true);	
		hueVariation.addChangeListener(this);		
		labelHueVar = new JLabel();
		labelHueVar.setText("Current value: " + new Integer(hueVariation.getValue()).toString());
		panelGenSet.add(labelHueVar);
		
		panelGenSet.add(Box.createRigidArea(BVStyle.RA_Y_L));
		
		panelGenSet.add(new JLabel("Hue Separation:"));		
		if(colorCheck.valuesSet) {
			hueSeperation = new JSlider(JSlider.HORIZONTAL, CUtils.HUE_SEP_MIN, 
				CUtils.HUE_SEP_MAX, colorCheck.hueSep);
		} else {
			hueSeperation = new JSlider(JSlider.HORIZONTAL, CUtils.HUE_SEP_MIN, 
					CUtils.HUE_SEP_MAX, CUtils.HUE_SEP_INIT);			
		}
		panelGenSet.add(hueSeperation);
		hueSeperation.setAlignmentX(Component.LEFT_ALIGNMENT);
		hueSeperation.addChangeListener(this);
		hueSeperation.setMajorTickSpacing(10);
		hueSeperation.setMinorTickSpacing(5);
		hueSeperation.setPaintTicks(true);
		hueSeperation.setPaintLabels(true);
		labelHueSep = new JLabel();
		labelHueSep.setText("Current value: " + new Integer(hueSeperation.getValue()).toString());
		panelGenSet.add(labelHueSep);
		
		panelGenSet.add(Box.createRigidArea(BVStyle.RA_Y_L));
		
		JPanel panelTestNum = new JPanel();
		panelTestNum.setLayout(new BoxLayout(panelTestNum, BoxLayout.X_AXIS));
		panelTestNum.setAlignmentX(Component.LEFT_ALIGNMENT);
		panelGenSet.add(panelTestNum);
		
		panelTestNum.add(new JLabel("Test Number: "));		
		textTestNum = new JTextField();
		textTestNum.setMaximumSize(BVStyle.TF_W_L);
		if(colorCheck.valuesSet) {
			textTestNum.setText(colorCheck.testNum);
		} else {
			textTestNum.setText("");
		}
		panelTestNum.add(textTestNum);
		
		JPanel panelGenRandom = new JPanel();
		panelGenRandom.setLayout(new BoxLayout(panelGenRandom, BoxLayout.X_AXIS));
		panelGenRandom.setAlignmentX(Component.LEFT_ALIGNMENT);
		panelGenSet.add(panelGenRandom);
		

		checkRandom = new JCheckBox();
		checkRandom.addActionListener(this);
		if(colorCheck.valuesSet) {
			if(colorCheck.randomTest) {
				checkRandom.setSelected(true);
				textTestNum.setEnabled(false);
			} else {
				checkRandom.setSelected(false);
				textTestNum.setEnabled(true);
			}
		} else {
			checkRandom.setSelected(true);
			textTestNum.setEnabled(false);			
		}
		panelGenRandom.add(checkRandom);
		panelGenRandom.add(new JLabel("Randomly generate"));	
		
		
		return panelGenSet;
	}

	
	private double confOneX;
	private double confOneY;
	private double confTwoX;
	private double confTwoY;
	
	public void actionPerformed(ActionEvent e) {

		
		if(e.getSource() == buttonCancel) {
			//make no changes
			this.setVisible(false);
		} else if(e.getSource() == buttonSet) {
	        int buttonNum;
			
	        if(confPresetDeuA.isSelected()) {
	        	buttonNum = 1;
	        } else if(confPresetDeuB.isSelected()) {
	        	buttonNum = 2;
	        } else if(confPresetProA.isSelected()) {
	        	buttonNum = 3;
	        } else if(confPresetProB.isSelected()) {
	        	buttonNum = 4;
	        } else {
		        buttonNum = 5;
		    }
	        
			colorCheck.setColorCheckValues( 
					confOneX,	
					confOneY,
					confTwoX,  
					confTwoY,
					brightnessVariation.getValue(),
					hueVariation.getValue(),
					hueSeperation.getValue(),
					checkRandom.isSelected(),
					textTestNum.getText(),
					buttonNum);
	        
			this.setVisible(false);
		} else if(e.getSource() == checkRandom) {
			if(checkRandom.isSelected()) {
				textTestNum.setEnabled(false);
			} else {
				textTestNum.setEnabled(true);
			}
		} else if(e.getSource() == confPresetDeuA) {
			confOneX = CUtils.DEU_A_ONE_X;
			confOneY = CUtils.DEU_A_ONE_Y;
			confTwoX = CUtils.DEU_A_TWO_X;
			confTwoY = CUtils.DEU_A_TWO_Y;
			repaint();
		} else if(e.getSource() == confPresetDeuB) {
			confOneX = CUtils.DEU_B_ONE_X;
			confOneY = CUtils.DEU_B_ONE_Y;
			confTwoX = CUtils.DEU_B_TWO_X;
			confTwoY = CUtils.DEU_B_TWO_Y;
			repaint();
		} else if(e.getSource() == confPresetProA) {
			confOneX = CUtils.PRO_A_ONE_X;
			confOneY = CUtils.PRO_A_ONE_Y;
			confTwoX = CUtils.PRO_A_TWO_X;
			confTwoY = CUtils.PRO_A_TWO_Y;
			repaint();
		} else if(e.getSource() == confPresetProB) {
			confOneX = CUtils.PRO_B_ONE_X;
			confOneY = CUtils.PRO_B_ONE_Y;
			confTwoX = CUtils.PRO_B_TWO_X;
			confTwoY = CUtils.PRO_B_TWO_Y;
			repaint();
		} else {
			confOneX = 0;
			confOneY = 0;
			confTwoX = 0;
			confTwoY = 0;
			repaint();
		}
	}

	public void stateChanged(ChangeEvent arg0) {
		labelBriVar.setText("Current value: " + new Integer(brightnessVariation.getValue()).toString());
		labelHueVar.setText("Current value: " + new Integer(hueVariation.getValue()).toString());
		labelHueSep.setText("Current value: " + new Integer(hueSeperation.getValue()).toString());
		repaint();
	}
	

}
