%%%%%%%%%%% EE 362 Project                     %%%%%%%%%%%%%
%%%%%%%%%%% Timothy Atobatele & Ekine Akuiyibo.%%%%%%%%%%%%% 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% 1. Project Examples/Experiment scripts
% Gaussian Blur Example
wdw = 5;
var = 1.5;
gCoeff = fspecial('gaussian',wdw,var);
n_gCoeff = gCoeff/max(gCoeff(:));
surfc(n_gCoeff); colormap(gray);
figure; imagesc(n_gCoeff); colormap(gray); axis image;
% imwrite(n_gCoeff,'gaussian_5_1.png')

% Slanted bar Example
wdw = 5;
% slanted
slantCoeff = triu(ones(wdw,wdw));
surfc(slantCoeff); colormap(gray);
figure; imagesc(slantCoeff); colormap(gray); axis image;
% imwrite(slantCoeff,'range_slant_5.png')

% Bilateral Product Example
slantbi = n_gCoeff.*slantCoeff;
figure; imagesc(slantbi); colormap(gray); axis image;
surfc(slantbi); colormap(gray);
% imwrite(slantbi,'bi_slant_5.png')

% Straight Line Example
cols = 2;
straightCoeff = [zeros(wdw,cols) ones(wdw,wdw-cols)];
surfc(straightCoeff); colormap(gray);
figure; imagesc(straightCoeff); colormap(gray); axis image;
% imwrite(straightCoeff,'range_straight_5.png')

% Bilateral Product Example
linebi = n_gCoeff.*straightCoeff;
figure; imagesc(linebi); colormap(gray); axis image;
surfc(linebi); colormap(gray);
% imwrite(linebi,'bi_straight_5.png')


% 2. BILINEAR DEMOSAICKING
clear
img = imread('animalsCrop.tif');
img1 = bilinearDemosaicing(img);
imwrite(img1,'animalsCrop_bilinear.tif') 
clear
img = imread('macbethMosaicCrop.tif');
img1 = bilinearDemosaicing(img);
imwrite(img1,'macbethMosaicCrop_bilinear.tif') 
clear
img = imread('mackayCrop.tif');
img1 = bilinearDemosaicing(img);
imwrite(img1,'mackayCrop_bilinear.tif') 
clear
img = imread('slantedBarCrop.tif');
img1 = bilinearDemosaicing(img);
imwrite(img1,'slantedBarCrop_bilinear.tif') 


% 3. BILATERAL DEMOSAICKING

% Demosaic
% Write out PNG files for better internet viewing
% YCBCR
clear, close all;
img = imread('animalsCrop.tif');
% figure; imagesc(img);axis image;
img1 = bilateral_filter3(img,1,1,'ycb','ycb');
imwrite(img,'ycb_animalsCrop.png')
imwrite(img1,'ycb_animals_b3.png')

img = imread('macbethMosaicCrop.tif');
% figure; imagesc(img);axis image;
img1 = bilateral_filter3(img,1,1,'ycb','ycb');
imwrite(img,'ycb_macbethMosaicCrop.png');
imwrite(img1,'ycb_macbeth_b3.png')

img = imread('mackayCrop.tif');
% figure; imagesc(img);axis image;
img1 = bilateral_filter3(img,1,1,'ycb','ycb');
imwrite(img,'ycb_mackayCrop.png')
imwrite(img1,'ycb_mackay_b3.png')

img = imread('slantedBarCrop.tif');
% figure; imagesc(img);axis image;
img1 = bilateral_filter3(img,1,1,'ycb','ycb');
imwrite(img,'ycb_slantedBar.png')
imwrite(img1,'ycb_slantedBar_b3.png')

% RGB
clear, close all;
img = imread('animalsCrop.tif');
% figure; imagesc(img);axis image;
img1 = bilateral_filter3(img,1,1,'rgb','rgb');
imwrite(img1,'rgb_animals_b3.png')

img = imread('macbethMosaicCrop.tif');
% figure; imagesc(img);axis image;
img1 = bilateral_filter3(img,1,1,'rgb','rgb');
imwrite(img1,'rgb_macbeth_b3.png')

img = imread('mackayCrop.tif');
% figure; imagesc(img);axis image;
img1 = bilateral_filter3(img,1,1,'rgb','rgb');
imwrite(img1,'rgb_mackay_b3.png')

img = imread('slantedBarCrop.tif');
% figure; imagesc(img);axis image;
img1 = bilateral_filter3(img,1,1,'rgb','rgb');
imwrite(img1,'rgb_slantedBar_b3.png')

% HSV
clear, close all;
img = imread('animalsCrop.tif');
% figure; imagesc(img);axis image;
img1 = bilateral_filter3(img,1,1,'hsv','hsv');
imwrite(img1,'hsv_animals_b3.png')

img = imread('macbethMosaicCrop.tif');
% figure; imagesc(img);axis image;
img1 = bilateral_filter3(img,1,1,'hsv','hsv');
imwrite(img1,'hsv_macbeth_b3.png')

img = imread('mackayCrop.tif');
% figure; imagesc(img);axis image;
img1 = bilateral_filter3(img,1,1,'hsv','hsv');
imwrite(img1,'hsv_mackay_b3.png')

img = imread('slantedBarCrop.tif');
% figure; imagesc(img);axis image;
img1 = bilateral_filter3(img,1,1,'hsv','hsv');
imwrite(img1,'hsv_slantedBar_b3.png')

% CIELAB
clear, close all;
img = imread('animalsCrop.tif');
% figure; imagesc(img);axis image;
img1 = bilateral_filter3(img,1,1,'hsv','hsv');
imwrite(img1,'lab_animals_b3.png')

img = imread('macbethMosaicCrop.tif');
% figure; imagesc(img);axis image;
img1 = bilateral_filter3(img,1,1,'hsv','hsv');
imwrite(img1,'lab_macbeth_b3.png')

img = imread('mackayCrop.tif');
% figure; imagesc(img);axis image;
img1 = bilateral_filter3(img,1,1,'hsv','hsv');
imwrite(img1,'lab_mackay_b3.png')

img = imread('slantedBarCrop.tif');
% figure; imagesc(img);axis image;
img1 = bilateral_filter3(img,1,1,'hsv','hsv');
imwrite(img1,'lab_slantedBar_b3.png')


% 4. DENOISING
clear, close all;

% einstein
load einstein;
I = X/255;
N = rand(256)-0.5;
J = I + N;

% other image
% density = 0.2;
% I = imread('eight.tif');
% J = imnoise(I,'gaussian', 0.20);

% imwrite(gaussian_d,'gaussian_<windowSize>.tif')
% var_d = 1;
% coeff_d = 1/(2*var_d^2);
% wdw = max(1, ceil(2.1*var_d));
% sqr_wdw = ([-wdw:wdw].^2)'; 
% gCoeff = exp(-coeff_d*sqr_wdw);
% gCoeff_d = gCoeff*gCoeff';

% Extra Stuff
% animals
clear, close all;
rect = [60 100 40 40];

img = imread('animalsCrop.tif');
figure; imagesc(img);axis image;
imsect = imcrop(img,rect);
figure; imagesc(imsect);axis image;
% imwrite(imsect,'animalsCrop_section.tif')

img1 = imread('animalsCrop_bilinear.tif');
figure; imagesc(img1);axis image;
imsect1 = imcrop(img1,rect);
figure; imagesc(imsect1);axis image;
imwrite(imsect,'animalsCrop_bilinear_section.tif')

img2 = imread('animalsCrop_TM_bi.tif');
figure; imagesc(img2);axis image;
imsect2 = imcrop(img2,rect);
figure; imagesc(imsect2);axis image;
% imwrite(imsect,'animalsCrop_TM_bi_section.tif')

% macbeth
clear, close all;
rect = [60 100 40 40];

img = imread('macbethMosaicCrop.tif');
figure; imagesc(img);axis image;
imsect = imcrop(img,rect);
figure; imagesc(imsect);axis image;
imwrite(imsect,'macbethMosaicCrop_section.tif')

img1 = imread('macbethMosaicCrop_bilinear.tif');
figure; imagesc(img1);axis image;
imsect1 = imcrop(img1,rect);
figure; imagesc(imsect1);axis image;
imwrite(imsect,'macbethMosaicCrop_bilinear_section.tif')

img2 = imread('macbethMosaicCrop_TM_bi.tif');
figure; imagesc(img2);axis image;
imsect2 = imcrop(img2,rect);
figure; imagesc(imsect2);axis image;
imwrite(imsect,'macbethMosaicCrop_TM_bi_section.tif')

% mackay
clear, close all;
rect = [60 100 40 40];

img = imread('mackayCrop.tif');
figure; imagesc(img);axis image;
imsect = imcrop(img,rect);
figure; imagesc(imsect);axis image;
imwrite(imsect,'mackayCrop_section.tif')

img1 = imread('mackayCrop_bilinear.tif');
figure; imagesc(img1);axis image;
imsect1 = imcrop(img1,rect);
figure; imagesc(imsect1);axis image;
imwrite(imsect,'mackayCrop_bilinear_section.tif')

img2 = imread('mackayCrop_TM_bi.tif');
figure; imagesc(img2);axis image;
imsect2 = imcrop(img2,rect);
figure; imagesc(imsect2);axis image;
imwrite(imsect,'mackayCrop_TM_bi_section.tif')

% slantedBar
clear, close all;
rect = [60 100 40 40];

img = imread('slantedBarCrop.tif');
figure; imagesc(img);axis image;
imsect = imcrop(img,rect);
figure; imagesc(imsect);axis image;
imwrite(imsect,'slantedBarCrop_section.tif')

img1 = imread('slantedBarCrop_bilinear.tif');
figure; imagesc(img1);axis image;
imsect1 = imcrop(img1,rect);
figure; imagesc(imsect1);axis image;
imwrite(imsect,'slantedBarCrop_bilinear_section.tif')

img2 = imread('slantedBarCrop_TM_bi.tif');
figure; imagesc(img2);axis image;
imsect2 = imcrop(img2,rect);
figure; imagesc(imsect2);axis image;
imwrite(imsect,'slantedBarCrop_TM_bi_section.tif')

K = medfilt2(J);
G = filter2(gCoeff_d,J);
B = bilateral(J,2,1);
figure; imagesc(I); colormap(gray); axis image; title('Original Image');
figure; imagesc(J); colormap(gray); axis image; title('Noise Image');
figure; imagesc(K); colormap(gray); axis image; title('Median Filtered Imagae');
figure; imagesc(G); colormap(gray); axis image; title('Gaussian Blur Filtered Image');
figure; imagesc(B); colormap(gray); axis image; title('Bilateral Filtered Image');

% MSE
% Variance Test

Var = [1 1.2 1.4 1.6 1.8 2]

img = imread('lighthousemosaic.jpg');
img = im2double(img);

img1 = bilateral_filter3(img,1,Var(1),'ycb','ycb');
error = img - img1;
errSqr = error.^2;
meanSqrErr1 = mean(sum(mean(errSqr)));
figure
imshow(errSqr,[]);
title('Light House Error Image, Domain Variance = 1');

img2 = bilateral_filter3(img,1,Var(2),'ycb','ycb');
error2 = img - img2;
errSqr2 = error2.^2;
meanSqrErr2 = mean(sum(mean(errSqr2)));

img3 = bilateral_filter3(img,1,Var(3),'ycb','ycb');
error3 = img - img3;
errSqr3 = error3.^2;
meanSqrErr3 = mean(sum(mean(errSqr3)));

img4 = bilateral_filter3(img,1,Var(4),'ycb','ycb');
error4 = img - img4;
errSqr4 = error4.^2;
meanSqrErr4 = mean(sum(mean(errSqr4)));

img5 = bilateral_filter3(img,1,Var(5),'ycb','ycb');
error5 = img - img5;
errSqr5 = error5.^2;
meanSqrErr5 = mean(sum(mean(errSqr5)));

img6 = bilateral_filter3(img,1,Var(6),'ycb','ycb');
error6 = img - img6;
errSqr6 = error6.^2;
meanSqrErr6 = mean(sum(mean(errSqr6)));

meanSqrErr = [meanSqrErr1 meanSqrErr2 meanSqrErr3 meanSqrErr4 meanSqrErr5 meanSqrErr6];

figure
plot(Var,meanSqrErr);
title('Mean Squared Error vs. Variance Plot');
xlabel('Domain Variance');
ylabel('Mean Squared Error');


% LIGHT HOUSE BILINEAR
img10 = bilinearDemosaicing(img);
imwrite(img10,'lighthouse_bilinear.png') 

