function labim=xyz2lab(xyzim);

% Converts image specified in xyz to images specified in CIELAB using D65
% as the whitepoint
%
% inputs:
%   xyzim       3D matrix, xyz values for each pixel
%   whitepoint  3 row vector with xyz of whitepoint
%
% output:  
%   labim       3D matrix, LAB values for each pixel

% xyz values for D65
Xn=94.811;
Yn=100;
Zn=107.304;

whitepoint=[Xn Yn Zn]';

% put image into form to work with
x = xyzim(:,:,1);
y = xyzim(:,:,2);
z = xyzim(:,:,3);
x=x(:);
y=y(:);
z=z(:);

xyzMat=[x y z];

% convert!
labMat=vcXYZ2lab(xyzMat, whitepoint,0);

% put image back into 3D matrix
L=labMat(:,1);
a=labMat(:,2);
b=labMat(:,3);

L=reshape(L, size(xyzim,1), size(xyzim,2));
a=reshape(a, size(xyzim,1), size(xyzim,2));
b=reshape(b, size(xyzim,1), size(xyzim,2));

labim(:,:,1)=L;
labim(:,:,2)=a;
labim(:,:,3)=b;