function picWW = whiteworld(pic)
% Transforms pixels so that brightest pixel (minimum euclidean distance from 
% white(1, 1, 1)) is equal to white 

[rows, cols, colors] = size(pic);

max_vals = [1 1 1];
dist = zeros(rows, cols);

% Find Euclidean Distance of each pixel to white (1,1,1)
for i = 1:rows
    for j = 1:cols
        p(1) = pic(i, j, 1);
        p(2) = pic(i, j, 2);
        p(3) = pic(i, j, 3);
        dist(i, j) = sum((max_vals - p).^2);
    end
end

% Find Minimum Distance from White
[min_int_rows min_rows] = min(dist);
[min_int min_col] = min(min_int_rows);
min_row = min_rows(min_col);

% Calculate Transformation Coefficients
kr = 1/pic(min_row, min_col, 1);
kg = 1/pic(min_row, min_col, 2);
kb = 1/pic(min_row, min_col, 3);

% Scale-by-max Balanced Picture
picWW = zeros(size(pic));   

% Apply Transformation
picWW(:,:,1) = kr*pic(:,:,1);
picWW(:,:,2) = kg*pic(:,:,2);
picWW(:,:,3) = kb*pic(:,:,3);

% Truncate all values above 1 so they equal 1
picWW(find(picWW(:,:,:) > 1)) = 1;
