function picV = std_hist(pic)
% If the image has large regions that are vastly different intensities, it
% performs a variance modulation on those regions individually (to avoid
% pushing bright regions into saturation, or dark regions to zero)


% Histogram of Picture
[rows, cols, colors] = size(pic);
[h, x] = hist(reshape(pic, rows*cols,3), 100);

% Flag that is set to 1 if there are not multiple regions of different
% intensity
var_flag = 0;

y = h;
picV = zeros(size(pic));
stdDesired = 70/255;

% Low-pass filter histogram
for i = 1:(length(x)-4)
    y(i+2, :) = (h(i, :) + h(i+1, :) + h(i+2, :) + h(i+3, :) + h(i+4, :))/5;
end

% Main channel loop
for j = [2 1 3]
    picColor{j} = pic(:,:,j);
    index{j} = zeros(1, length(y));
    count = 1;
    % Find any local maxima, where the frequency of occurence is above 500
    for k = 1:(length(y)-2)
        if y(k+1, j) > y(k, j) & y(k+1, j) > y(k+2, j)
            if y(k, j) > 500
                index{j}(count) = x(k+1);
                count = count+1;
            end
        end
    end
    index{j}(find(index{j}(:)==0)) = [];
    % Remove any local maxima that are closer than .15 intensity points to
    % each other (roughly equivalent to 40 points on a 255 scale)
    for p = 1:(length(index{j})-1)
        if (index{j}(p+1)-index{j}(p)) < .15
            index{j}(p) = 0;
        end
    end
    index{j}(find(index{j}(:) == 0)) = [];
    % If there is only 1 peak, set flag
    if length(index{2}) < 2
        var_flag = 1
        break;
    end
    cut{j} = zeros(1, (length(index{j})-1));
    cut_index{j} = zeros(1, (length(index{j})-1));
    % Use green channel only to find mask
    if j == 2
        % Calculate cutoff values that are to be used to separate
        % regions
        for q = 1:(length(index{j})-1)
            x_temp1 = find(x == index{j}(q));
            x_temp2 = find(x == index{j}(q+1));
            int_ratio = y(x_temp1, j)/y(x_temp2, j);
            if int_ratio > 1
                int_ratio = 1/int_ratio;
                cut{j}(q) = index{j}(q) + (1-int_ratio)*(index{j}(q+1)-index{j}(q)); % equiv to: index{j}(q+1) - int_ratio(index{j}(q+1)-index{j}(q))
            else
                cut{j}(q) = index{j}(q) + (int_ratio)*(index{j}(q+1)-index{j}(q));
            end
            temp_x = x;
            temp_x(find(x < cut{j}(q))) = [];
            cut_index{j}(q) = temp_x(1);
            cut_index{j}(q) = find(x == cut_index{j}(q));
            picInt{j, q} = pic(:, :, j);
            % Create Images for each region
            try cut_index{j}(q-1)   % Runs if q > 1, i.e. everytime except on the first cutoff
                picInt{j, q}(find(picInt{j, q} < x(cut_index{j}(q)))) = 0;
                picInt{j, q+1} = pic(:, :, j) - picInt{j, q};
                picInt{j, q} = picInt{j, q} - picInt{j, q-1};
            catch   % runs if q == 1
                picInt{j, q}(find(pic(:, :, j) > x(cut_index{j}(q)))) = 0;
                picInt{j, q+1} = pic(:, :, j) - picInt{j, q};
            end
        end
    end
    % Extract images in other two color channels
    if j ~= 2
        for q = 1:(length(index{2}))
            picInt{j, q} = pic(:, :, j);
            picInt{j, q}(find(picInt{2,q} == 0)) = 0;
        end
    end
    numPixels{j} = zeros(1, length(index{j}));
    meanRegion{j} = zeros(1, length(index{j}));
    stdRegion{j} = zeros(1, length(index{j}));

    for s = 1:length(index{j})
        tempPic = picInt{j, s};
        tempPic(find(picInt{j, s} == 0)) = [];
        % Calculate mean and std
        numPixels{j}(s) = length(tempPic);
        meanRegion{j}(s) = mean(tempPic)
        stdRegion{j}(s) = std(tempPic);
        tempPic = picInt{j, s} - meanRegion{j}(s);
        tempPic(find(tempPic == -1*meanRegion{j}(s))) = -2;
        % Calculate std adjustment factor
        stdFactor = (numPixels{j}(s)/(rows*cols))*stdDesired/stdRegion{j}(s);
        % Modify factor if it is too low (occurs with small regions)
        if stdFactor < 2
            stdFactor = stdFactor*2;
        end
        tempPic = tempPic*stdFactor;
        % Testing done with mean adjustments (needs to be made adaptive)
        if meanRegion{j}(s) < .3
            meanRegion{j}(s) = meanRegion{j}(s) + .1;
        end
%         if meanRegion{j}(s) > .4
%             meanRegion{j}(s) = meanRegion{j}(s)+.3;
%         end
        tempPic(find(tempPic > -2)) = tempPic(find(tempPic > -2)) + meanRegion{j}(s);
        % Truncate all values above 1 so they equal 1
        tempPic(find(tempPic(:,:) > 1)) = 1;
        tempPic(find(tempPic(:,:) < 0)) = 0;
        picV(:, :, j) = picV(:, :, j) + tempPic;
    end
end

if var_flag == 1
    picV = std_balance(pic);
end

% Truncate all values above 1 so they equal 1
picV(find(picV(:,:,:) > 1)) = 1;
picV(find(picV(:,:,:) < 0)) = 0;