function picV = std_balance(pic)
% Performs std modulation on the image so that the standard deviation of
% the image equals some perceptually pleasing value

% Extract each channel
picR = pic(:,:,1);
picG = pic(:,:,2);
picB = pic(:,:,3);
% Calculate Channel Means
meanR = mean(mean(picR));
meanG = mean(mean(picG));
meanB = mean(mean(picB));
% Calculate Channel Standard Deviations
stdR = std(picR(:));
stdG = std(picG(:));
stdB = std(picB(:));

% Desired Channel Std
stdDesired = 70/255;

% Mean/Std Balanced Picture
picV = zeros(size(pic));

% Apply Transformation
picV(:,:, 1) = (stdDesired/stdR)*(pic(:,:,1) - meanR) + meanR;
picV(:,:, 2) = (stdDesired/stdG)*(pic(:,:,2) - meanG) + meanG;
picV(:,:, 3) = (stdDesired/stdB)*(pic(:,:,3) - meanB) + meanB;

% Truncate all values above 1 so they equal 1
picV(find(picV(:,:,:) > 1)) = 1;
picV(find(picV(:,:,:) < 0)) = 0;