function picMax = scale_by_max(pic)
% Scales each channel with the factor needed set each respective channel maximum equal to 1

% Calculate Constants and Balance Matrix
kr = 1/max(max(pic(:,:,1)));
kg = 1/max(max(pic(:,:,2)));
kb = 1/max(max(pic(:,:,3)));

% Scale-by-max Balanced Picture
picMax = zeros(size(pic));    

% Apply Transformation
picMax(:,:,1) = kr*pic(:,:,1);
picMax(:,:,2) = kg*pic(:,:,2);
picMax(:,:,3) = kb*pic(:,:,3);