function xyzim=rgb2xyz(rgbim);

% Converts RGB values to XYZ values
%
% input:   three-element row vector with R, G, B
% output:  three-element row vector with X, Y, Z

% load SPD's of R, G and B (camera specific)
load crtSPD;
crtPhosphors=data;

% load XYZ basis functions
load XYZ;
XYZ = data;

% % make XYZ data into same format as RGB data (one sample every 10 nm from
% % 400 nm to 700 nm)
% XYZ=XYZ(31:10:331,:);
wavelength=wavelength(31:10:331);

% convert 3D matrix into 2D matrix with R, G, B as columns        
R = rgbim(:,:,1);
G = rgbim(:,:,2);
B = rgbim(:,:,3);
R=R(:);
G=G(:);
B=B(:);

rgbMat=[R G B];

% convert!
energy = rgbMat*crtPhosphors';
xyzMat = ieXYZFromEnergy(energy,wavelength);


% convert 2D matrix back to 3D matrix
x=xyzMat(:,1);
y=xyzMat(:,2);
z=xyzMat(:,3);

x=reshape(x, size(rgbim,1), size(rgbim,2));
y=reshape(y, size(rgbim,1), size(rgbim,2));
z=reshape(z, size(rgbim,1), size(rgbim,2));

xyzim(:,:,1)=x;
xyzim(:,:,2)=y;
xyzim(:,:,3)=z;