function mseRGB = mse_rgb(pic1, pic2)
% Unweighted MSE in RGB Color space
%
% Inputs:   two RGB images (3D matrices)
% Output:   MSE in RGB color space (double)
%

% difference image in RGB space
e=pic1-pic2;

% Unweighted in RGB color space %
e1=e(:,:,1);
e2=e(:,:,2);
e3=e(:,:,3);

% get one number out of the differences in each channel for each pixel
mseRGB=sqrt(mse(e1)^2+mse(e2)^2+mse(e3)^2);