function mseFREQ = mse_freq(pic1, pic2)
% Frequency Weighted MSE in CIELAB Colorspace
%
% Inputs:   two RGB images (3D matrices)
% Output:   Frequency weighted MSE in CIELAB color space (double)
%

% Unweighted in CIELAB color space
pic1LAB=xyz2lab(rgb2xyz(pic1));
pic2LAB=xyz2lab(rgb2xyz(pic2));

eLAB=pic1LAB-pic2LAB;
deltaL=eLAB(:,:,1);
deltaA=eLAB(:,:,2);
deltaB=eLAB(:,:,3);

deltaE=sqrt(deltaL.^2+deltaA.^2+deltaB.^2);


% Calculate weights using blocks

% make image dimensions divisible by 8

% pic1
if (floor(size(pic1,1)/8) ~= size(pic1,1)/8)
    % # rows not divisible by 8, truncate image
    pic1=pic1(1:floor(size(pic1,1)/8)*8,:,:);
    deltaE=deltaE(1:floor(size(pic1,1)/8)*8,:,:);
end
if (floor(size(pic1,2)/8) ~= size(pic1,2)/8)
    % # columns not divisible by 8, truncate image
    pic1=pic1(:,1:floor(size(pic1,2)/8)*8,:);
    deltaE=deltaE(:,1:floor(size(pic1,2)/8)*8,:);
end

% pic2
if (floor(size(pic2,1)/8) ~= size(pic2,1)/8)
    % # rows not divisible by 8, truncate image
    pic2=pic2(1:floor(size(pic2,1)/8)*8,:,:);
    deltaE=deltaE(1:floor(size(pic2,1)/8)*8,:,:);
end
if (floor(size(pic2,2)/8) ~= size(pic2,2)/8)
    % # columns not divisible by 8, truncate image
    pic2=pic2(:,1:floor(size(pic2,2)/8)*8,:);
    deltaE=deltaE(:,1:floor(size(pic2,2)/8)*8,:);
end

% for each 8x8 block, do an fft, remove low frequencies (gradual filter),
% take mean
for i=1:8:size(pic1,1)
    for j=1:8:size(pic1,2)
        blockRGB=pic1(i:i+7,j:j+7,:);
        blockInt(:,:)=blockRGB(:,:,1)+blockRGB(:,:,2)+blockRGB(:,:,3);
        blockFFT=fftshift(fft2(blockInt));
        
        mask=gausswin(8,2)*gausswin(8,2)';
        mask=mask./max(max(mask));
        mask = 1 - mask;
        mask(find(mask< 0)) = 0;
%         mask=mask(1:8,1:8);
%         mask(1,1)=0;
        
        blockFFT=blockFFT.*mask;

        meanMat(i:i+7,j:j+7)=mean(mean(abs(blockFFT)));     
    end
end

% take care of possible 0 in the matrix with the mean values
tempMean = meanMat;
tempMean(find(tempMean == 0)) = [];
if length(find(tempMean == 0)) == 0
    tempMean = min(min(tempMean));
else
    tempMean = min(tempMean);
end
meanMat(find(meanMat == 0)) = tempMean;

% calculate weights
% many high frequency components => low weights (1/value)
weights=1./meanMat;
% weights(find(weights == 'Inf')) = max(max(weights));
weights=weights/max(max(weights));

% weight all pixels in a block by the weight assigned to that block
deltaEw=deltaE.*weights;

% get one number out of the weighted deltaE's
mseFREQ=mse(deltaEw);