function mseCIELAB = mse_cielab(pic1, pic2)
% MSE in CIELAB color space
%
% Inputs:   two RGB images (3D matrices)
% Output:   MSE in CIELAB color space (double)

% Unweighted in CIELAB color space
% Convert both images to LAB values
pic1LAB=xyz2lab(rgb2xyz(pic1));
pic2LAB=xyz2lab(rgb2xyz(pic2));

% Take difference
eLAB=pic1LAB-pic2LAB;
deltaL=eLAB(:,:,1);
deltaA=eLAB(:,:,2);
deltaB=eLAB(:,:,3);

% Calculate deltaE according to standard formula
deltaE=sqrt(deltaL.^2+deltaA.^2+deltaB.^2);

% Get one number of all the deltaE's
mseCIELAB=mse(deltaE);