function picMW = medianworld(pic)
% Scales R and B channels based on the difference in median to the G color
% channel

% Extract each color channel
picR = pic(:, :, 1);
picG = pic(:, :, 2);
picB = pic(:, :, 3);

% Sum up Colors
medianR = median(picR(:));
medianG = median(picG(:));
medianB = median(picB(:));

% Calculate Transformation Coefficients
kr = medianG/medianR;
kg = 1;
kb = medianG/medianB;

% Gray-World Balanced Picture
picMW = zeros(size(pic)); 

% Apply Transformation
picMW(:,:,1) = kr*pic(:,:,1);
picMW(:,:,2) = kg*pic(:,:,2);
picMW(:,:,3) = kb*pic(:,:,3);

% Truncate all values above 1 so they equal 1
picMW(find(picMW(:,:,:) > 1)) = 1;