function picGW = grayworld(pic)
% Scales R and B channels so they have the same mean as the G channel
% (Grayworld)

% Sum up Colors
sumR = sum(sum(pic(:,:,1)));
sumG = sum(sum(pic(:,:,2)));
sumB = sum(sum(pic(:,:,3)));

% Calculate Transformation Coefficients
kr = sumG/sumR;
kg = 1;
kb = sumG/sumB;

% Gray-World Balanced Picture
picGW = zeros(size(pic)); 

% Apply Transformation
picGW(:,:,1) = kr*pic(:,:,1);
picGW(:,:,2) = kg*pic(:,:,2);
picGW(:,:,3) = kb*pic(:,:,3);

% Truncate all values above 1 so they equal 1
picGW(find(picGW(:,:,:) > 1)) = 1;