function color_balance(directory, alg_flag, name_flag, illum_flag, mse_flag, adjustment, prgm_flag)
% Color Balancing
% Program performs color balancing on the specified input image under the
% specified illuminants using the specified algorithm.
% The program can output a montage of the color balanced image or various
% MSE results into a MS Excel spreadsheet.


% Initialize Constants
name = {'Macbeth', 'WhiteFlowers', 'Volvo', 'MemorialChurch', 'StuffedAnimals', 'CarTrophies', 'Pepppers', 'FengShadow', 'FengOffice'};
illum = {'', '_d65', '_tungsten', '_fluorescent', '_daylight'};

%%% Add New Algorithm name at the end of variable alg_name!
alg_name = {'Grayworld', 'Whiteworld', 'Scale-by-Max', 'Median', 'Mean/Std', 'Cast', 'MS/GW',...
    'GW/MS', 'GW/Std', 'Std', 'SBM/MS', 'MS/SBM', 'WW/MS', 'MS/WW', 'STD Mod', 'WW/STD', 'Blurred GW', 'Blurred MS'};
mse_name = {'RGB', 'CIELAB', 'Frequency Weighted'};

% Initialize Excel Spreadsheet
excel_mse_name = ['MSE ' name{name_flag}];
excel_mse_data(1, 1) = {['Mean Square Error: ' name{name_flag}]};

% Set Row 2 (MSE Row) in Excel
for m = 1:length(mse_flag)
    excel_mse_data(2, 2+length(illum_flag)*(m-1)) = {mse_name{mse_flag(m)}};
end

if prgm_flag == 1   % Not needed for MSE
    % Find Output Montage Dimensions
    max_cols = ceil(sqrt(length(alg_flag)+1));
    if max_cols < 3
        max_cols = 3;
    end
    rows = floor(length(alg_flag)/max_cols)+1;
    cols = length(alg_flag)+1;
    if cols > max_cols
        cols = max_cols;
    end
end

% Main Illuminant Loop
for j = 1:length(illum_flag)

    % Set Row 3 (Illuminant Row) in Excel
    for k = 1:length(mse_flag)
        if isempty(illum{illum_flag(j)})
            excel_mse_data(3, 1+j+length(illum_flag)*(k-1)) = {'Nothing'};
        else
            excel_mse_data(3, 1+j+length(illum_flag)*(k-1)) = {illum{illum_flag(j)}(2:end)};
        end
    end

    % Load Image and Apply Gamma
    if length(directory ~= 0)
        directory = [directory '\'];
    end
    load([directory name{name_flag} illum{illum_flag(j)}]);
    pic = rgbDisplay;
    pic = pic.^adjustment;

    if prgm_flag == 1   % Not needed for MSE
        % Prepare Output Montage
        temp_pic = zeros(size(pic,1)*rows, size(pic,2)*cols);
        final_pic(:,:,1) = temp_pic;
        final_pic(:,:,2) = temp_pic;
        final_pic(:,:,3) = temp_pic;
        % Place Original in top right of Montage
        final_pic(1:size(pic,1), 1:size(pic,2), :) = pic;
    end

    % Algorithm Loop
    for i = 1:length(alg_flag)

        % Set Column 1 (Algorithm Column) in Excel
        excel_mse_data(i+3, 1) = {alg_name{alg_flag(i)}};

        % Color Balance Image
        switch alg_flag(i)
            case 1
                mod_pic = grayworld(pic);
            case 2
                mod_pic = whiteworld(pic);
            case 3
                mod_pic = scale_by_max(pic);
            case 4
                mod_pic = medianworld(pic);
            case 5
                mod_pic = mean_std(pic);
            case 6
                mod_pic = cast(pic);
            case 7
                mod_pic = mean_std(pic);
                mod_pic = grayworld(mod_pic);
            case 8
                mod_pic = grayworld(pic);
                mod_pic = mean_std(mod_pic);
            case 9
                mod_pic = grayworld(pic);
                mod_pic = std_balance(mod_pic);
            case 10
                mod_pic = std_balance(pic);
            case 11
                mod_pic = scale_by_max(pic);
                mod_pic = mean_std(mod_pic);
            case 12
                mod_pic = mean_std(pic);
                mod_pic = scale_by_max(mod_pic);
            case 13
                mod_pic = whiteworld(pic);
                mod_pic = mean_std(mod_pic);
            case 14
                mod_pic = mean_std(pic);
                mod_pic = whiteworld(mod_pic);
            case 15
                mod_pic = region_std(pic);
            case 16
                mod_pic = whiteworld(pic);
                mod_pic = std_balance(mod_pic);
            case 17
                mod_pic = blurGW(pic);
            case 18
                mod_pic = blur_mean_std(pic);
                %%% Add New Algorithm Here ! %%%
                % ex. case xx
                %         mod_pic = myColorBalancingFunc(pic);
                %%% Add name of algorithm at top of file to variable alg_name!
        end

        if prgm_flag == 1 % Not needed for MSE
            % Calculate Placement in Output Montage
            rowStart = 1+size(pic,1)*floor(i/max_cols);
            rowEnd = size(pic,1)*(floor(i/max_cols)+1);
            colStart = 1+size(pic,2)*mod(i,max_cols);
            colEnd = size(pic,2)*(mod(i,max_cols)+1);
            % Place Color Balance Pic in Output Montage
            final_pic(rowStart:rowEnd,colStart:colEnd, :) = mod_pic;

            % Load Ideal Image
            load([directory name{name_flag} illum{1}]);
            ideal_pic = rgbDisplay;
            ideal_pic = ideal_pic.^adjustment;
        elseif i == 1
            ideal_pic = mod_pic;
        end

        % Calculate MSE
        for n = 1:length(mse_flag)
            switch mse_flag(n)
                case 1
                    % Calculate and Output RGB MSE to Excel
                    excel_mse_data(3+i, 1+j+length(illum_flag)*(n-1)) = {num2str(mse_rgb(ideal_pic, mod_pic))};
                case 2
                    % Calculate and Output CIELAB MSE to Excel
                    excel_mse_data(3+i, 1+j+length(illum_flag)*(n-1)) = {num2str(mse_cielab(ideal_pic, mod_pic))};
                case 3
                    % Calculate and Output Frequency Weighted MSE to Excel
                    excel_mse_data(3+i, 1+j+length(illum_flag)*(n-1)) = {num2str(mse_freq(ideal_pic, mod_pic))};
            end
        end
    end

    if prgm_flag == 1
        % Show Output Image
        figure
        imshow(final_pic)
        title(['Balanced ' illum{illum_flag(j)}(2:end) ' Picture (w/ adjustment = ' num2str(adjustment) ')']);
        xString = 'Original';
        for p = 1:length(alg_flag)
            xString = [xString ', ' alg_name{alg_flag(p)}];
        end
        xlabel(xString);
    end
end

% Output Excel file
if length(mse_flag) > 0
    xlswrite(excel_mse_name, excel_mse_data);
end
