function uncastPic=cast(pic);

% Removes red, green or blue color cast
%
% inputs:
%  pic         RGB image
%
% outputs:
%  uncastPic   RGB image of same size as input

meanDes = 128/255;
meanThresh = 100/255;

meanR=mean(mean(pic(:,:,1)));
meanG=mean(mean(pic(:,:,2)));
meanB=mean(mean(pic(:,:,3)));

if meanR > meanThresh
    pic(:,:,1)=pic(:,:,1)*meanDes/meanR;
end

if meanG > meanThresh
    pic(:,:,2)=pic(:,:,2)*meanDes/meanG;
end

if meanB > meanThresh
    pic(:,:,3)=pic(:,:,3)*meanDes/meanB;
end

uncastPic=pic;
