function picMS = blur_mean_std(pic)
% Set each channel's mean and std to equal a desired mean and std values
% Mean and std are calculated based on a blurred version of the image

% Low pass filter
lpf = (1/225)*ones(15);

% Extract color channels
picR = pic(:,:,1);
picG = pic(:,:,2);
picB = pic(:,:,3);

% Filter each channel
picR = filter2(lpf, picR);
picG = filter2(lpf, picG);
picB = filter2(lpf, picB);

% Calculate Channel Means
meanR = mean(mean(picR));
meanG = mean(mean(picG));
meanB = mean(mean(picB));

% Calculate Channel Standard Deviations
stdR = std(picR(:));
stdG = std(picG(:));
stdB = std(picB(:));

% Desired Channel Mean and Std
meanDesired = 128/255;
stdDesired = 70/255;

% Mean/Std Balanced Picture
picMS = zeros(size(pic));

% Apply Transformation
picMS(:,:, 1) = (stdDesired/stdR)*(pic(:,:,1) - meanR) + meanDesired;
picMS(:,:, 2) = (stdDesired/stdG)*(pic(:,:,2) - meanG) + meanDesired;
picMS(:,:, 3) = (stdDesired/stdB)*(pic(:,:,3) - meanB) + meanDesired;

% Truncated all values above 1 and below 0 to equal 1 and 0
picBlur(find(picMS(:,:,:) > 1)) = 1;
picBlur(find(picMS(:,:,:) < 0)) = 0;