function picBlur = blurGW(in_pic)
% Computes transform coefficients on blurred version of input image
% (grayworld method)

% Low-pass Fitler
lpf = (1/225)*ones(15);
blur_pic = in_pic;

% Extract each channel and apply filter
for i = 1:3
    pic{i} = in_pic(:, :, i);
    blur_pic(:,:,i) = filter2(lpf, pic{i});
end

% Sum up Colors
sumR = sum(sum(blur_pic(:,:,1)));
sumG = sum(sum(blur_pic(:,:,2)));
sumB = sum(sum(blur_pic(:,:,3)));

% Calculate Transformation Coefficients
kr = sumG/sumR;
kg = 1;
kb = sumG/sumB;

% Gray-World Balanced Picture
picBlur = zeros(size(in_pic)); 

% Apply Transformation
picBlur(:,:,1) = kr*pic{1};
picBlur(:,:,2) = kg*pic{2};
picBlur(:,:,3) = kb*pic{3};

% Truncate all values above 1 so they equal 1
picBlur(find(picBlur(:,:,:) > 1)) = 1;





