% Color Balancing MSE:
% Allows the user to an image that will be color balanced.
% The user can specify which algorithms to use on the image and if the
% testing should be done with multiple illuminants. Results are output to
% an MS Excel spreadsheet with the name specified by the name of the input
% image.

clear all; close all;

% Directory of Input RGB Images (Use '' if they are in the program directory)
directory = 'C:\Documents and Settings\meyerlab\Desktop\362 project\v3\Images';

% Algorithms to use (1-7) (1 = Grayworld, 2 = Whiteworld, 3 = Scale-by-max,
% 4 = Median, 5 = Mean/Std, 6 = Cast, 7 = MS/GW (same as 5), 8 = GW/MS (same as 5), 
% 9 = GW/Std, 10 = Std, 11 =SBM/MS , 12 = MS/SBM,13 = WW/MS, 14 = MS/WW, 15 = Region Std, 
% 16 = WW/Std, 17 = Blurred Grayworld, 18 = Blurred MS)
% Note: To Add color balancing algorithm, goto color_balance_mse.m and search
% for '%%%'. All you need to do is write the algorithm name and the
% function call.
% Note: Optimal Image must be placed first!
% alg_flag = [1 17];
alg_flag = [5 18];

% Brightness Adjustment Value (Set to 1 for normal images) (Our image set
% had very dark images, so we adjusted them to make them visible)
adjustment = .4;

% Name of Image to Use (1-9) (1 = macbeth, 2 = white flowers, 3 = license plate,
% 4 = memorial church, 5 = stuffed animals, 6 = trophies, 7 = peppers,
% 8 = feng in quad, 9 = feng in office)
name_flag = 1;

% Illuminants to Use (1-5) (1 = none, 2 = d65, 3 = tungsten,
% 4 = fluorescent, 5 = daylight)
illum_flag = [3];

% MSE Measurements to Use (1-3) (1 = RGB, 2 = CIELAB, 3 = Frequency Weighted)
mse_flag = [1 2 3];

color_balance(directory, alg_flag, name_flag, illum_flag, mse_flag, adjustment, 0);
% Final argument, is a flag indicating which program is calling the
% function (it is not to be changed)