
function [sigma, mu] = statsCluster(pixels, mask)

% STATSCLUSTER - calculates the mean and STD of the given cluster
%
%  [SIGMA, MU] = STATSCLUSTER(PIXELS,MASK)
%
%  Input:
%       PIXELS - MxNx3 image, where each pixel is a point in a 
%                perceptually unif color space (e.g. LAB). note that this image
%                should have been masked (i.e. contain only those pixels in this cluster)
%      MASK - MxN binary image that's a mask for this cluster
%
%  Output: 
%       SIGMA - standard deviation of this cluster. the STD calculated is
%               the std of distance from the mean 
%       MU - 1x3 vector containing the mean L, A, and B values of this cluster
%
% Jeff Walters & Angi Chau
% Feb 2003

% first find the mean of the cluster (and we have to make sure to ignore
% all the pixels not in this cluster)
indices = find(mask~=0);
Lonly = pixels(:,:,1);
Aonly = pixels(:,:,2);
Bonly = pixels(:,:,3);
mu = [mean(Lonly(indices)) mean(Aonly(indices)) mean(Bonly(indices))];

%if (numPixels > 0)
    sd = sqdist(pixels, mu).*mask;
    %sigma2 = sum(sigma2(1:end)); % sum of all distances
    %sigma = sqrt(sigma2/numPixels);  % normalize & sqrt to get std
    
    % now we want to find the std of the distances
    sigma=std(sqrt(sd(indices)));
    %sigma=std(sd(1:end));
%end



