function tower = showPyramid(pyr, distances)

% M = SHOWPYRAMID(PYR) displays the multiscale pyramid of images
% created by CREATEPYRAMID. PYR is an MxNx3xL matrix containing the
% LAB values for the L levels in the pyramid and distances contains
% the L distances.
%
% Jeff Walters & Angi Chau
% Feb 2003

% pyr is height x width x 3 x evels
[h,w,c,levels] = size(pyr);

% we need the whitepoint to convert from LAB space
RGB_WHITE = [1 1 1]';
whiteXYZ = changeColorSpace(RGB_WHITE, cmatrix('rgb2xyz'));
% white point always has Y=100
whiteXYZ = whiteXYZ./whiteXYZ(2)*100;

load displayGamma;

figure;
for ind=1:levels

    subplot(levels,1,ind);
    
    % convert from lab values to RGB values
    thisXYZ = lab2xyz(pyr(:,:,:,ind), whiteXYZ);
    imgLinearRGB = changeColorSpace(thisXYZ, cmatrix('xyz2rgb'));
    
    % correct for silly RGB values
%     indices = find(imgLinearRGB < 0);
%     imgLinearRGB(indices) = 0;
%     indices = find(imgLinearRGB>1);
%     imgLinearRGB(indices) = 1;

    % gamma correct for monitor
    imgRGB = dac2rgb(imgLinearRGB,invGamma);
    
    % display
    imagesc(imgRGB./255);
    axis image;
    axis off;
    title(sprintf('distance=%d',distances(ind)));
end