

function [finalMasks, finalConfs]= segment(filename, distances, K, LAB_DIFF, PERCENTAGE, PERCEPTUAL)

CONFIDENCE_THRESHOLD = 0.8;

disp('********************');
disp('Pre-proceesing Image')
disp('********************');

[pyr,masks,confidences,stds,means] = preprocess(filename,distances, K, LAB_DIFF, PERCENTAGE, PERCEPTUAL);

lastMasks = masks;
lastPtheta = confidences;

numLevels = size(pyr,4);

disp('********************');
disp('Begin relaxation')
disp('********************');

% work our way up the pyramid
for pyrind = numLevels-1:-1:1,
    disp(sprintf('Working on level %d',pyrind));
    currImage = pyr(:,:,:,pyrind);
    [h,w,c] = size(currImage);
    
    % this is the one done with color histograms
    currPx = calculatePXTheta(currImage, lastMasks);
    
    % this is the Q function
    currQ = calculateQ(currImage, lastMasks, currPx, lastPtheta);
    
    % get the new prob assignments
    confs = currPx.*lastPtheta.*currQ;
    
    % now we need to normalize across clusters
    sumConfs = sum(confs,3);
    disp('normalizing all confidences');

    numClusters = size(confs,3);
    for ind=1:numClusters,
        confs(:,:,ind) = confs(:,:,ind) ./ sumConfs;
    end 

    % create the new masks% form a set of new masks and confidences by taking out any empty regions
    newMasks = zeros(h,w,0);
    newPtheta = zeros(h,w,0);
    %newPtheta = confs;
    
    disp('making new masks');
    for j=1:numClusters,
        % go thru each plane of confidences and pick out the ones with conf > THRESHOLD
        mask = (confs(:,:,j) >= CONFIDENCE_THRESHOLD);
        if (sum(mask(:)) ~= 0)
            disp(sprintf('cluster %d is not empty --> adding to output',j));
            newMasks(:,:,end+1) = mask;
            newPtheta(:,:,end+1) = confs(:,:,j);
            %else
            %disp(sprintf('cluster %d is empty --> adding to output',j));
            %newMasks(:,:,end+1) = mask;
        end
   end
    
    showClusters(newMasks);
    title(sprintf('core clusters at level %d',pyrind));
    
    % set stuff up for the next iteration
    lastMasks = newMasks;
    lastPtheta = newPtheta;
end

% return the final set of masks and confidences (ON THE LAST LEVEL...MAYBE USE MAX INSTEAD OD 80%)
finalConfs = lastPtheta;

[h,w,c] = size(finalConfs);

% for the last level, we're going to create masks without using the threshold. just take the max.
finalMasks = zeros(h,w,c);
for j=1:numClusters,
    % go thru each plane of confidences and pick out the ones with conf > THRESHOLD
    finalMasks(:,:,j) = (finalConfs(:,:,j) == max(finalConfs,[],3));
end
showClusters(finalMasks);
title('final clusters');
