function groups = kclassify(samples, means)

% KCLASSIFY Classification based on k-means (no dependence on dimension)
%
%  Samples: A matrix with rows containing sample vectors
%  Means: A matrix with C rows, each of which is a group mean.
  
% First, compute the distances of each sample from each of the
% means.
  
  numPixels = length(samples(:,1));
  numGroups = size(means,1);
  groups = zeros(numPixels,1);
  
  tic
  for i=1:numPixels
      
      % #1
      %[jive, groups(i)] = min(distances(samples(i,:), means));
      
      % #2  11s for K=1000
      vm = repmat(samples(i,:), numGroups, 1);     
      dists = sum((vm - means).^2, 2);

      % #3
      %dists = zeros(numGroups,1);
      %for j=1:numGroups
      %    dists(j) = sum((samples(i,:)-means(j,:)).^2);
      %end

      % #4  
%       str='dists=[ ';
%       for j=1:length(means(:,1))
%           str = strcat(str,sprintf('sum((samples(%d,:)-means(%d,:)).^2), ',i,j));
%       end
%       str = strcat(str,'];');
%       eval(str);
      
      [dontcare, groups(i)] = min(dists);
      
  end
  toc
  
  
  