/* A replacement for fast(sparse(S,1,1,n,1)) because this should be fast.
 *
 * Usage x=hist5hel(S,n) with all elements of S integers in the
 * range 1..n gives x(i)=sum(S==i).
 * 
 * Written for Matlab 5 by Hans Olsson 1997-06-26
 *    Department of Computer Science
 *    Lund University
 *    Sweden
 *
 *    E-mail: Hans.Olsson@dna.lth.se
 *
 *          
 */


#include <math.h>
#include <ctype.h>
#include "mex.h" 
          /* mex.h is included with the Matlab shipment */


/* some preprocessor definitions */

#define	min(A, B)	((A) < (B) ? (A) : (B))
#define mrows(A)	(mxGetM(A))
#define ncols(A)	(mxGetN(A))
#define realdata(A)	(mxGetPr(A))

void mexFunction(int nlhs,mxArray*plhs[],int nrhs,const mxArray*prhs[]) 
{
  const double *y_in;
  long int n,i,n_in;
  double *x_out;
  if (nrhs<1 || nrhs>2) 
    mexErrMsgTxt("histmultihelp.c: wrong number of input arguments.");
  if (nlhs !=1 ) 
    mexErrMsgTxt("histmultihelp.c: wrong number of output arguments.");

  y_in=realdata(prhs[0]);
  n=*realdata(prhs[1]); /* Range of data is 1..n */

  plhs[0]=mxCreateDoubleMatrix(n,1,mxREAL);
  x_out=realdata(plhs[0]);

  n_in=mxGetM(prhs[0])*mxGetN(prhs[0]);

  /* Zero all elements :*/
  for(i=0;i<n;i++) x_out[i]=0.0;

  /* Go through the elements and add the to their positions */
  for(i=0;i<n_in;i++) {
    long int index=y_in[i];
    if ((index>=1)&&(index<=n))
      x_out[index-1]+=1.0;
  };
}

