function d = distances(v, m)
%  DISTANCES Squared euclidean distances (works on vectors of any
%  dimension)
%
% D is a vector containing the squared Euclidean distance of V from
% each row of M.
%
% using repmat, takes 0.0013s
%  
  
  v = v(:)';     % make into row vec
  
  % get the current "pixel" ready for comparison to all groups
  vm = repmat(v, length(m(:,1)), 1);     
  d = sum((vm - m).^2,2);  % sum of sq differences of each dimension
  
   
  
  