function Q = calculateQ(im, prevClusters, pxtheta, prevClusterProbabilities)
% CALCULATEQ - Calculate Q, as deinfed my Mermehdi & Petrou
% 
% Input:
%      IM - MxNx3 image, where each pixel is a point in a
%      perceptually uniform color space.
%
%      PREVCLUSTERS - MxNx3 matrix that contains binary masks
%      representing a pixels membership in a certain cluster as of
%      the previous scale.
%
%      PXTHETA - MxNx3 matrix as calculated by CALCULATEPXTHETA
%
%      PREVCLUSTERPROBABILITIES - MxNxC matrix where the (i,j,k)
%      entry is the probability that pixel (i,j) is a member of
%      class k.
%  
% Output:
%      Q - Q (duh), as defined by Mirmehdi & Petrou, calculated for
%      every pixel in the image.  An MxN matrix.
%        
  
  
  % first, we need to create masks that represent each of the
  % entries in the 'pattern dictionary'.  Use the dictionary
  % defined in the M&P paper.
    
  load patternDictionary;
  patternsA = patterns;
  patternsB = ~patterns;
  clear patterns;
  
  numPatterns = length(patternsA(1,1,:));
  [M,N,numClusters] = size(prevClusters);
  
% $$$   % calculate a matrix that contains all class pairings
% $$$   pairs = nchoosek(1:numClusters,2);
% $$$   numPairs = length(pairs(:,1));
% $$$   disp(sprintf(['Calculating Q using a pattern dictionary of length' ...
% $$$ 		' %d and %d possible cluster pairings'], ...
% $$$ 	       numPatterns,numPairs));
  
  Q = zeros(M,N,numClusters);

  % we need to calculate lots of products, but if we note that
  % log(A)+log(B) = log(AB), we can use built in convolution
  % routines, which are much faster
  
  probs = log(prevClusterProbabilities.*pxtheta+eps);

   for j=1:numClusters
     temp =  sum(convn(probs(:,:,j),patternsA,'same'),3);
     disp(sprintf('Max temp = %f',min(max(temp))));
     Q(:,:,j) = Q(:,:,j) + temp;
     for k=1:numClusters
      if ( j ~= k )
 	temp = sum(convn(probs(:,:,k),patternsB,'same'),3);
 	Q(:,:,j) = Q(:,:,j) + temp;
       end
    end
   end
  
   Q = exp(Q) - eps;
% $$$   tempB = zeros(M,N,numPatterns);
% $$$   for i=1:numClusters
% $$$     tempA = zeros(M,N,numPatterns);
% $$$     for j=1:numPatterns
% $$$       tempA(:,:,j) = convProd(probs(:,:,i),patternsA(:,:,j));
% $$$     end
% $$$     
% $$$     for j=1:numClusters
% $$$       if (i ~= j)
% $$$ 	for k=1:numPatterns
% $$$ 	  tempB(:,:,k) = convProd(probs(:,:,j),patternsB(:,:,k));
% $$$ 	end
% $$$ 	Q(:,:,i) = Q(:,:,i) + sum(tempB.*tempA,3);
% $$$       end
% $$$     end
% $$$   end